/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;

public class DockerPortRequestCustomizer
implements HttpConfiguration.Customizer {
    private final String nexusContextPath;
    private final String repositoryName;

    public DockerPortRequestCustomizer(String nexusContextPath, String repositoryName) {
        this.nexusContextPath = nexusContextPath;
        this.repositoryName = repositoryName;
    }

    public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
        HttpURI uri = request.getHttpURI();
        String version = null;
        if (uri.getPath().startsWith("/v1")) {
            version = "/v1";
        } else if (uri.getPath().startsWith("/v2")) {
            version = "/v2";
        }
        if (version != null) {
            request.setHttpURI(new HttpURI(uri.toString().replaceFirst(version, String.valueOf(this.nexusContextPath) + "repository/" + this.repositoryName + version)));
            request.setMetaData(request.getMetaData());
        } else {
            try {
                request.getResponse().sendError(400, "Not a Docker request");
                request.setHandled(true);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

