/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.internal.DockerGroupWriteHandler;
import org.sonatype.nexus.repository.docker.internal.V2Handlers;
import org.sonatype.nexus.repository.docker.internal.V2Manifest;
import org.sonatype.nexus.repository.docker.internal.V2ManifestUtil;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class DockerGroupWriteManifestHandler
extends DockerGroupWriteHandler {
    static final String MANIFEST_VERIFIED_ATTR = "manifestVerified";
    private final V2ManifestUtil v2ManifestUtil;

    @Inject
    public DockerGroupWriteManifestHandler(V2ManifestUtil v2ManifestUtil) {
        this.v2ManifestUtil = (V2ManifestUtil)Preconditions.checkNotNull((Object)v2ManifestUtil);
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Context copyContext = context.replayable();
        Payload payload = (Payload)Preconditions.checkNotNull((Object)copyContext.getRequest().getPayload());
        Repository repository = context.getRepository();
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        this.verifyManifest(repository, payload, V2Handlers.requireName(state), V2Handlers.tag(state));
        copyContext.getAttributes().set(MANIFEST_VERIFIED_ATTR, (Object)true);
        return super.handle(copyContext);
    }

    private void verifyManifest(Repository repository, Payload payload, String name, String tag) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Payload p = payload;){
            V2Manifest manifest = this.v2ManifestUtil.readManifest(() -> ((Payload)p).openInputStream(), name, payload.getContentType());
            this.v2ManifestUtil.validateManifest(repository, name, tag, manifest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

