/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.docker.internal.DockerForeignLayerEntityAdapter;
import org.sonatype.nexus.repository.docker.internal.DockerForeignLayerUrls;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class DockerForeignLayerSource
extends StateGuardLifecycleSupport {
    private final Provider<DatabaseInstance> databaseInstance;
    private final DockerForeignLayerEntityAdapter adapter;

    @Inject
    public DockerForeignLayerSource(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, DockerForeignLayerEntityAdapter adapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.adapter = (DockerForeignLayerEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)adapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.adapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    public List<String> getForeignLayerUrls(String digest) {
        Objects.requireNonNull(digest);
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> {
            DockerForeignLayerUrls entity = this.adapter.read(db, digest);
            return entity == null ? null : entity.getUrls();
        });
    }

    public void updateForeignLayerUrls(String digest, List<String> urls) {
        Objects.requireNonNull(digest);
        Objects.requireNonNull(urls);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            DockerForeignLayerUrls entity = this.adapter.read(db, digest);
            if (entity == null) {
                entity = this.adapter.newEntity();
                entity.setDigest(digest);
                entity.setUrls(urls);
                this.adapter.addEntity(db, (Entity)entity);
            } else if (!entity.getUrls().equals(urls)) {
                entity.setUrls(urls);
                this.adapter.update(db, entity);
            }
        });
    }
}

