/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.http.HttpScheme;
import org.slf4j.Logger;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorRegistrar;
import org.sonatype.nexus.bootstrap.jetty.DockerSubdomainRepositoryMapping;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.docker.DockerConnectorFacet;
import org.sonatype.nexus.repository.docker.internal.DockerConnectorConfiguration;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeatureControlService;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.sonatype.nexus.validation.ConstraintViolations;
import org.sonatype.nexus.validation.constraint.PortNumber;

@Named
public class DockerConnectorFacetImpl
extends FacetSupport
implements DockerConnectorFacet {
    private static final Pattern SUBDOMAIN_REGEX_PATTERN = Pattern.compile("[A-Za-z](?:[A-Za-z0-9\\-]{0,61}[A-Za-z0-9])?");
    static final String CONFIG_KEY = "docker";
    private final RepositoryManager repositoryManager;
    private final ConstraintViolationFactory constraintViolationFactory;
    private final ConnectorRegistrar connectorRegistrar;
    private final String nexusContextPath;
    private final DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService;
    private Config config;
    private ConnectorConfiguration httpConfig;
    private ConnectorConfiguration httpsConfig;

    @Inject
    public DockerConnectorFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, ConnectorRegistrar connectorRegistrar, @Named(value="${nexus-context-path}") @Named(value="${nexus-context-path}") String nexusContextPath, DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.connectorRegistrar = (ConnectorRegistrar)Preconditions.checkNotNull((Object)connectorRegistrar);
        this.nexusContextPath = String.valueOf((String)Preconditions.checkNotNull((Object)nexusContextPath)) + (nexusContextPath.endsWith("/") ? "" : "/");
        this.dockerSubdomainFeatureControlService = dockerSubdomainFeatureControlService;
    }

    protected void doValidate(Configuration configuration) {
        ConfigurationFacet configurationFacet = this.getConfigurationFacet();
        configurationFacet.validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
        Config configToValidate = (Config)configurationFacet.readSection(configuration, CONFIG_KEY, Config.class);
        HashSet violations = new HashSet();
        if (this.dockerSubdomainFeatureControlService.isFeatureAllowed()) {
            this.subdomainConstraintViolation(violations, configToValidate);
        }
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validatePortNotInUse(DockerConnectorFacetImpl.pathOf("httpPort"), configToValidate.httpPort, this.getHttpPort())});
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validatePortNotInUse(DockerConnectorFacetImpl.pathOf("httpsPort"), configToValidate.httpsPort, this.getHttpsPort())});
        ConstraintViolations.maybeAdd(violations, this.validateNotSamePort(DockerConnectorFacetImpl.pathOf("httpPort"), configToValidate.httpPort, DockerConnectorFacetImpl.pathOf("httpsPort"), configToValidate.httpsPort));
        ConstraintViolations.maybePropagate(violations, (Logger)this.log);
    }

    @VisibleForTesting
    protected void subdomainConstraintViolation(Set<ConstraintViolation<?>> violations, Config configToValidate) {
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateSubdomain(configToValidate.subdomain)});
        ConstraintViolations.maybeAdd(violations, (ConstraintViolation[])new ConstraintViolation[]{this.validateSubdomainNotInUse(configToValidate.subdomain)});
    }

    @VisibleForTesting
    protected ConfigurationFacet getConfigurationFacet() {
        return (ConfigurationFacet)this.facet(ConfigurationFacet.class);
    }

    protected void doConfigure(Configuration configuration) {
        this.config = (Config)this.getConfigurationFacet().readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doStart() {
        if (this.dockerSubdomainFeatureControlService.isFeatureAllowed() && this.config.subdomain != null) {
            this.doStartSubdomain(this.config.subdomain);
        }
        if (this.config.httpPort != null) {
            this.httpConfig = this.startConnector(this.getRepository().getName(), HttpScheme.HTTP, this.config.httpPort);
        }
        if (this.config.httpsPort != null) {
            this.httpsConfig = this.startConnector(this.getRepository().getName(), HttpScheme.HTTPS, this.config.httpsPort);
        }
    }

    @VisibleForTesting
    protected void doStartSubdomain(String subdomain) {
        DockerSubdomainRepositoryMapping.put((String)subdomain, (String)this.getRepositoryName());
    }

    @VisibleForTesting
    protected String getRepositoryName() {
        return this.getRepository().getName();
    }

    private ConnectorConfiguration startConnector(String repositoryName, HttpScheme scheme, Integer port) {
        try {
            DockerConnectorConfiguration connectorConfig = new DockerConnectorConfiguration(this.nexusContextPath, repositoryName, scheme, port);
            this.connectorRegistrar.addConnector((ConnectorConfiguration)connectorConfig);
            return connectorConfig;
        }
        catch (Exception e) {
            this.log.warn("Could not configure {} connector on port {} for docker repository {}", new Object[]{scheme, port, this.getRepository().getName(), e});
            return null;
        }
    }

    protected void doStop() {
        if (this.httpConfig != null) {
            this.connectorRegistrar.removeConnector(this.httpConfig);
        }
        if (this.httpsConfig != null) {
            this.connectorRegistrar.removeConnector(this.httpsConfig);
        }
        if (this.dockerSubdomainFeatureControlService.isFeatureAllowed() && this.config.subdomain != null) {
            this.doStopSubdomain(this.config.subdomain);
        }
    }

    @VisibleForTesting
    protected void doStopSubdomain(String subdomain) {
        DockerSubdomainRepositoryMapping.remove((String)subdomain);
    }

    @Override
    @Nullable
    public Integer getHttpPort() {
        return this.config == null ? null : this.config.httpPort;
    }

    @Override
    @Nullable
    public Integer getHttpsPort() {
        return this.config == null ? null : this.config.httpsPort;
    }

    @Override
    @Nullable
    public Boolean isForceBasicAuth() {
        return this.config == null ? null : this.config.forceBasicAuth;
    }

    @Override
    @Nullable
    public String getSubdomain() {
        return this.config == null ? null : this.config.subdomain;
    }

    private ConstraintViolation<?> validatePortNotInUse(String path, Integer newPort, Integer oldPort) {
        if (newPort != null) {
            ConstraintViolation<?> violation = this.validateWithRepositories(path, newPort);
            if (violation != null) {
                return violation;
            }
            return this.validateWithRegistrar(path, newPort, oldPort);
        }
        return null;
    }

    private ConstraintViolation<?> validateWithRepositories(String path, Integer newPort) {
        List<Repository> repositories;
        try {
            repositories = this.repositoryManager.browse();
        }
        catch (IllegalStateException illegalStateException) {
            repositories = Collections.emptyList();
        }
        for (Repository repository : repositories) {
            DockerConnectorFacet connectorFacet;
            if (!CONFIG_KEY.equals(repository.getFormat().getValue()) || repository.equals(this.getRepository()) || !newPort.equals((connectorFacet = (DockerConnectorFacet)repository.facet(DockerConnectorFacet.class)).getHttpPort()) && !newPort.equals(connectorFacet.getHttpsPort())) continue;
            return this.constraintViolationFactory.createViolation(path, "Port must be unique (conflicts with repository '" + repository.getName() + "')");
        }
        return null;
    }

    private ConstraintViolation<?> validateSubdomain(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        boolean matches = SUBDOMAIN_REGEX_PATTERN.matcher(value).matches();
        if (!matches) {
            return this.constraintViolationFactory.createViolation(DockerConnectorFacetImpl.pathOf("subdomain"), "Subdomain field must be a minimum of 1 and maximum of 63 characters (letters, numbers, and dashes) and must start with a letter and end with a letter or digit");
        }
        return null;
    }

    private ConstraintViolation<?> validateSubdomainNotInUse(String newSubdomain) {
        if (newSubdomain != null) {
            List<Repository> repositories;
            try {
                repositories = this.repositoryManager.browse();
            }
            catch (IllegalStateException illegalStateException) {
                repositories = Collections.emptyList();
            }
            for (Repository repository : repositories) {
                DockerConnectorFacet connectorFacet;
                if (!CONFIG_KEY.equals(repository.getFormat().getValue()) || repository.equals(this.getRepository()) || !newSubdomain.equals((connectorFacet = (DockerConnectorFacet)repository.facet(DockerConnectorFacet.class)).getSubdomain())) continue;
                return this.constraintViolationFactory.createViolation(DockerConnectorFacetImpl.pathOf("subdomain"), "Subdomain must be unique (conflicts with repository '" + repository.getName() + "')");
            }
        }
        return null;
    }

    private ConstraintViolation<?> validateWithRegistrar(String path, Integer newPort, Integer oldPort) {
        if (this.connectorRegistrar.unavailablePorts().contains(newPort) && !Objects.equals(newPort, oldPort)) {
            return this.constraintViolationFactory.createViolation(path, "Port is already in use");
        }
        return null;
    }

    private ConstraintViolation<?>[] validateNotSamePort(String httpPortPath, Integer httpPort, String httpsPortPath, Integer httpsPort) {
        if (httpPort != null && httpPort.equals(httpsPort)) {
            return new ConstraintViolation[]{this.constraintViolationFactory.createViolation(httpPortPath, "HTTP and HTTPs ports must be different"), this.constraintViolationFactory.createViolation(httpsPortPath, "HTTP and HTTPs ports must be different")};
        }
        return new ConstraintViolation[0];
    }

    private static String pathOf(String fieldName) {
        return "attributes.docker." + fieldName;
    }

    @VisibleForTesting
    protected static class Config {
        @PortNumber
        public Integer httpPort;
        @PortNumber
        public Integer httpsPort;
        public Boolean forceBasicAuth = true;
        public String subdomain;

        protected Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + ", subdomain=" + this.subdomain + "}";
        }
    }
}

