/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.internal;

import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.HttpConfiguration;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.repository.docker.internal.DockerPortRequestCustomizer;

public class DockerConnectorConfiguration
implements ConnectorConfiguration {
    private final String nexusContextPath;
    private final String repositoryName;
    private final HttpScheme scheme;
    private final int port;

    public DockerConnectorConfiguration(String nexusContextPath, String repositoryName, HttpScheme scheme, int port) {
        this.nexusContextPath = nexusContextPath;
        this.repositoryName = repositoryName;
        this.scheme = scheme;
        this.port = port;
    }

    public HttpScheme getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public HttpConfiguration customize(HttpConfiguration configuration) {
        HttpConfiguration httpConfig = new HttpConfiguration(configuration);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new DockerPortRequestCustomizer(this.nexusContextPath, this.repositoryName));
        return httpConfig;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "repositoryName=" + this.repositoryName + ", scheme=" + this.scheme + ", port=" + this.port + '}';
    }
}

