/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.datastore.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.docker.internal.AssetKind;
import org.sonatype.nexus.repository.docker.internal.DockerDigest;
import org.sonatype.nexus.repository.docker.internal.DockerFacetUtils;
import org.sonatype.nexus.repository.docker.internal.V1Exception;
import org.sonatype.nexus.repository.docker.internal.datastore.DockerContentFacet;
import org.sonatype.nexus.repository.docker.internal.datastore.recipe.DockerFacetDatabaseUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Named
@Singleton
public class DockerRepairComponent
extends ComponentSupport {
    private static final TokenParser tagParser = new TokenParser("/v1/repositories/{id:.+}/tags/{tag}");
    private static final String ID = "id";
    private static final String TAG = "tag";

    private void updateAsset(Repository repository, FluentAsset asset) {
        if (this.isRootLayer(asset)) {
            this.repairLayerMetadata(repository, asset, new ArrayList<String>());
        }
    }

    private void repairLayerMetadata(Repository repository, FluentAsset asset, List<String> children) {
        NestedAttributesMap attributes = asset.attributes().child("docker");
        children.add(0, (String)attributes.get("layerId", String.class));
        attributes.set("ancestry", children);
        Map<String, Object> layerMetadata = this.doReadLayerMetadata(repository, asset);
        attributes.set("arch", layerMetadata.get("os"));
        attributes.set("os", layerMetadata.get("architecture"));
        this.populateXDockerAttributes(asset, repository);
        asset.withAttribute("docker", (Object)attributes.backing());
        this.findAssetsWithParentLayer(repository, children.get(0)).forEach(childAsset -> this.repairLayerMetadata(repository, (FluentAsset)childAsset, (List<String>)new ArrayList<String>(children)));
    }

    private Map<String, Object> doReadLayerMetadata(Repository repository, FluentAsset asset) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Content content = asset.download();){
                return DockerFacetUtils.readLayerMetadata(() -> ((Content)content).openInputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new V1Exception.InvalidLayerMetadata(String.format("Unable to read layer metadata for %s in repository %s", asset.path(), repository.getName()));
        }
    }

    private void populateXDockerAttributes(FluentAsset metadataAsset, Repository repository) {
        String metadataAssetPath = metadataAsset.path();
        String layerName = metadataAssetPath.replace("json", "layer");
        DockerContentFacet facet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        Optional<FluentAsset> layerAsset = facet.findAsset(layerName);
        if (layerAsset.isPresent()) {
            try {
                DockerDigest dockerDigest = DockerFacetDatabaseUtils.calculateChecksum(metadataAsset.download(), layerAsset.get().download());
                NestedAttributesMap attributes = metadataAsset.attributes();
                attributes.child("docker").set("X-Docker-Size", (Object)layerAsset.get().download().getSize());
                attributes.child("docker").set("X-Docker-Checksum-Payload", (Object)dockerDigest.toString());
            }
            catch (IOException e) {
                this.log.warn("Unable to calculate checksum for {} in {} repository", new Object[]{metadataAsset.path(), repository.getName(), e});
            }
        } else {
            this.log.warn("Unable to find layer asset that corresponds to {}", (Object)metadataAssetPath);
        }
    }

    private Iterable<FluentAsset> findAssetsWithParentLayer(Repository repository, String layerId) {
        DockerContentFacet facet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        return facet.findV1ChildAssets(layerId);
    }

    private boolean isRootLayer(FluentAsset asset) {
        return AssetKind.LAYER_METADATA.name().equals(asset.kind()) && asset.attributes().child("docker").get("parent", String.class) == null;
    }

    private void repairComponentTag(Repository repository, FluentAsset asset) {
        String layerId;
        String metadataAssetPath;
        DockerContentFacet facet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
        Optional<FluentAsset> metadataAsset = facet.findAsset(metadataAssetPath = DockerFacetDatabaseUtils.assetPath(DockerFacetUtils.v1layerMetadataName(layerId = (String)asset.attributes().child("docker").get("layerId", String.class))));
        if (!metadataAsset.isPresent()) {
            this.log.warn("Unable to find asset {}", (Object)metadataAssetPath);
            return;
        }
        Map tokens = tagParser.parse(asset.path());
        if (tokens != null && tokens.containsKey(ID) && tokens.containsKey(TAG)) {
            String tag;
            String name = (String)tokens.get(ID);
            Optional<FluentComponent> tagComponent = facet.findComponentByNameAndTag(name, tag = (String)tokens.get(TAG));
            if (!tagComponent.isPresent()) {
                this.log.error("Unable to find tag component {}:{}", (Object)name, (Object)tag);
                return;
            }
            NestedAttributesMap componentAttributes = tagComponent.get().attributes().child("docker");
            componentAttributes.set("layerAncestry", metadataAsset.get().attributes().child("docker").get("ancestry"));
            tagComponent.get().withAttribute("docker", (Object)componentAttributes.backing());
        }
    }

    private boolean isTagAsset(FluentAsset asset) {
        return AssetKind.TAG.name().equals(asset.kind());
    }

    public void updateAssets(Repository repository) {
        if ("hosted".equals(repository.getType().getValue())) {
            DockerContentFacet facet = (DockerContentFacet)repository.facet(DockerContentFacet.class);
            Iterable assets = Continuations.iterableOf((arg_0, arg_1) -> ((FluentAssets)facet.assets()).browse(arg_0, arg_1));
            for (FluentAsset asset : assets) {
                this.updateAsset(repository, asset);
            }
            for (FluentAsset asset : assets) {
                if (!this.isTagAsset(asset)) continue;
                this.repairComponentTag(repository, asset);
            }
        }
    }
}

