/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.docker.api.model.DockerProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeatureControlService;
import org.sonatype.nexus.repository.rest.api.ProxyRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.ProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named
public class DockerProxyRepositoryApiRequestToConfigurationConverter
extends ProxyRepositoryApiRequestToConfigurationConverter<DockerProxyRepositoryApiRequest> {
    private final DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService;

    @Inject
    public DockerProxyRepositoryApiRequestToConfigurationConverter(RoutingRuleStore routingRuleStore, DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService) {
        super(routingRuleStore);
        this.dockerSubdomainFeatureControlService = dockerSubdomainFeatureControlService;
    }

    public Configuration convert(DockerProxyRepositoryApiRequest request) {
        Configuration configuration = super.convert((ProxyRepositoryApiRequest)request);
        configuration.attributes("docker").set("v1Enabled", (Object)request.getDocker().getV1Enabled());
        configuration.attributes("docker").set("forceBasicAuth", (Object)request.getDocker().getForceBasicAuth());
        configuration.attributes("docker").set("httpPort", (Object)request.getDocker().getHttpPort());
        configuration.attributes("docker").set("httpsPort", (Object)request.getDocker().getHttpsPort());
        if (this.dockerSubdomainFeatureControlService.isFeatureAllowed()) {
            configuration.attributes("docker").set("subdomain", (Object)request.getDocker().getSubdomain());
        }
        configuration.attributes("dockerProxy").set("indexType", (Object)request.getDockerProxy().getIndexType());
        configuration.attributes("dockerProxy").set("indexUrl", (Object)request.getDockerProxy().getIndexUrl());
        configuration.attributes("dockerProxy").set("cacheForeignLayers", (Object)request.getDockerProxy().getCacheForeignLayers());
        configuration.attributes("dockerProxy").set("foreignLayerUrlWhitelist", request.getDockerProxy().getForeignLayerUrlWhitelist());
        return configuration;
    }
}

