/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.docker.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.docker.api.model.DockerGroupRepositoryApiRequest;
import org.sonatype.nexus.repository.docker.internal.DockerSubdomainFeatureControlService;
import org.sonatype.nexus.repository.rest.GroupRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.GroupRepositoryApiRequest;

@Named
public class DockerGroupRepositoryApiRequestToConfigurationConverter
extends GroupRepositoryApiRequestToConfigurationConverter<DockerGroupRepositoryApiRequest> {
    private final DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService;

    @Inject
    public DockerGroupRepositoryApiRequestToConfigurationConverter(DockerSubdomainFeatureControlService dockerSubdomainFeatureControlService) {
        this.dockerSubdomainFeatureControlService = dockerSubdomainFeatureControlService;
    }

    public Configuration convert(DockerGroupRepositoryApiRequest request) {
        Configuration configuration = super.convert((GroupRepositoryApiRequest)request);
        configuration.attributes("docker").set("v1Enabled", (Object)request.getDocker().getV1Enabled());
        configuration.attributes("docker").set("forceBasicAuth", (Object)request.getDocker().getForceBasicAuth());
        configuration.attributes("docker").set("httpPort", (Object)request.getDocker().getHttpPort());
        configuration.attributes("docker").set("httpsPort", (Object)request.getDocker().getHttpsPort());
        if (this.dockerSubdomainFeatureControlService.isFeatureAllowed()) {
            configuration.attributes("docker").set("subdomain", (Object)request.getDocker().getSubdomain());
        }
        return configuration;
    }
}

