/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.sonatype.nexus.blobstore.restore.internal.DockerV2RestoreSupport;
import com.sonatype.nexus.blobstore.restore.internal.orient.OrientDockerRestore;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.docker.DockerRestoreFacet;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Singleton
@Named(value="v2")
public class OrientDockerV2Restore
extends DockerV2RestoreSupport
implements OrientDockerRestore {
    public static final String NAME = "v2";
    private static final String BLOBS_PREFIX = "v2/-/blobs/";
    private static final String CATALOG_NAME = "v2/_catalog";
    private static final TokenParser manifestTokenParser = new TokenParser("v2/{name:.+}/manifests/{tag}");
    private static final String TAG_LIST_PREFIX = "v2";

    public OrientDockerV2Restore() {
        super(manifestTokenParser, CATALOG_NAME, BLOBS_PREFIX, "v2");
    }

    @Override
    public void doRestore(AssetBlob assetBlob, DockerRestoreFacet facet, String blobName) {
        if (this.isBlob(blobName)) {
            facet.restoreV2Blob(blobName, assetBlob);
        } else {
            Map<String, String> token = this.parseManifest(blobName);
            if (token != null) {
                facet.restoreV2Manifest(blobName, assetBlob, token.get("name"));
            } else {
                token = this.parseManifestTag(blobName);
                if (token != null) {
                    facet.restoreV2Tag(assetBlob, token.get("name"), token.get("tag"));
                } else if (this.isCatalog(blobName)) {
                    facet.restoreV2Catalog(blobName, assetBlob);
                } else if (this.isTagList(blobName)) {
                    facet.restoreV2TagsList(blobName, assetBlob);
                } else {
                    this.log.warn("Unable to determine the asset type for restore {}", (Object)blobName);
                }
            }
        }
    }

    @Override
    public boolean requiresComponent(String blobName) {
        return this.parseManifestTag(blobName) != null;
    }
}

