/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.sonatype.nexus.blobstore.restore.internal.DockerV1RestoreSupport;
import com.sonatype.nexus.blobstore.restore.internal.orient.OrientDockerRestore;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.docker.DockerRestoreFacet;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Singleton
@Named(value="v1")
public class OrientDockerV1Restore
extends DockerV1RestoreSupport
implements OrientDockerRestore {
    public static final String NAME = "v1";
    private static final String EXTENSION = "extension";
    private static final String ID = "id";
    private static final TokenParser imagesTokenParser = new TokenParser("v1/repositories/{id:.+}/images");
    private static final TokenParser layerMetadataParser = new TokenParser("v1/images/{id}/{extension}");
    private static final TokenParser tagParser = new TokenParser("v1/repositories/{id:.+}/tags/{tag}");
    private static final TokenParser tagsParser = new TokenParser("v1/repositories/{id:.+}/tags");

    public OrientDockerV1Restore() {
        super(tagParser, tagsParser, layerMetadataParser, imagesTokenParser);
    }

    @Override
    public void doRestore(AssetBlob assetBlob, DockerRestoreFacet facet, String blobName) {
        if (this.isImages(blobName)) {
            facet.restoreV1Image(blobName, assetBlob);
        } else {
            Map<String, String> token = this.parseLayerMetadata(blobName);
            if (token != null) {
                facet.restoreV1LayerMetadata(blobName, assetBlob, token.get(ID), token.get(EXTENSION));
            } else {
                token = this.parseLayerContent(blobName);
                if (token != null) {
                    facet.restoreV1LayerContent(blobName, assetBlob, token.get(ID), token.get(EXTENSION));
                } else {
                    token = this.parseLayerAncestry(blobName);
                    if (token != null) {
                        facet.restoreV1LayerAncestry(blobName, assetBlob, token.get(ID), token.get(EXTENSION));
                    } else {
                        token = this.parseTag(blobName);
                        if (token != null) {
                            facet.restoreV1Tag(blobName, assetBlob, token.get(ID), token.get("tag"));
                        } else if (this.isTags(blobName)) {
                            facet.restoreV1Tags(blobName, assetBlob);
                        } else {
                            this.log.warn("Unable to determine the asset type for restore {}", (Object)blobName);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean requiresComponent(String blobName) {
        return this.parseTag(blobName) != null || this.isTags(blobName);
    }
}

