/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.blobstore.restore.internal.orient.OrientDockerRestore;
import com.sonatype.nexus.blobstore.restore.internal.orient.OrientDockerRestoreBlobData;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.DockerRestoreFacet;
import org.sonatype.nexus.repository.docker.orient.repair.DockerRepairComponent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;

@Singleton
@Named(value="docker")
public class OrientDockerRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<OrientDockerRestoreBlobData> {
    private final Map<String, OrientDockerRestore> restoreVersion;
    private final DockerRepairComponent dockerRepairComponent;

    @Inject
    public OrientDockerRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix, Map<String, OrientDockerRestore> restoreVersion, DockerRepairComponent dockerRepairComponent) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
        this.restoreVersion = (Map)Preconditions.checkNotNull(restoreVersion);
        this.dockerRepairComponent = (DockerRepairComponent)((Object)Preconditions.checkNotNull((Object)((Object)dockerRepairComponent)));
    }

    protected OrientDockerRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new OrientDockerRestoreBlobData(blobData);
    }

    protected boolean canAttemptRestore(OrientDockerRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional dockerRestoreFacet = repository.optionalFacet(DockerRestoreFacet.class);
        if (!dockerRestoreFacet.isPresent()) {
            this.log.warn("Skipping as Docker Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        if (!this.restoreVersion.containsKey("v1") || !this.restoreVersion.containsKey("v2")) {
            this.log.error("Docker restoration of type {} is missing", (Object)(this.restoreVersion.containsKey("v1") ? "v2" : "v1"));
            return false;
        }
        return true;
    }

    protected boolean componentRequired(OrientDockerRestoreBlobData restoreData) throws IOException {
        String path = restoreData.getBlobData().getBlobName();
        String dockerVersion = this.extractDockerVersionFromPath(path);
        return this.restoreVersion.containsKey(dockerVersion) && this.restoreVersion.get(dockerVersion).requiresComponent(path);
    }

    protected boolean shouldDeleteAsset(OrientDockerRestoreBlobData restoreData, RestoreBlobData blobData, String path) throws IOException {
        return this.componentRequired(restoreData);
    }

    protected Repository getRepository(@Nonnull OrientDockerRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    protected String getAssetPath(OrientDockerRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    protected boolean assetExists(OrientDockerRestoreBlobData data) throws IOException {
        Repository repository = data.getBlobData().getRepository();
        DockerRestoreFacet dockerRestoreFacet = (DockerRestoreFacet)repository.facet(DockerRestoreFacet.class);
        return dockerRestoreFacet.findAsset(repository, data.getBlobData().getBlobName()) != null;
    }

    protected void createAssetFromBlob(AssetBlob assetBlob, OrientDockerRestoreBlobData data) throws IOException {
        String version = data.getBlobData().getBlobName().substring(0, 2);
        if (this.restoreVersion.containsKey(version)) {
            this.log.info("Restoring a {} generated asset/component: {}", (Object)version, (Object)data.getBlobData().getBlobName());
            this.restoreVersion.get(version).restore(assetBlob, data);
        } else {
            this.log.error("Unable to restore Docker version {}, blob name {}", (Object)version, (Object)data.getBlobData().getBlobName());
        }
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.dockerRepairComponent.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of docker package metadata");
        }
    }

    @VisibleForTesting
    String extractDockerVersionFromPath(String path) {
        int index = path.indexOf(47);
        if (index != -1) {
            return path.substring(0, index);
        }
        return null;
    }
}

