/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.datastore;

import com.sonatype.nexus.blobstore.restore.internal.DockerV2RestoreSupport;
import com.sonatype.nexus.blobstore.restore.internal.datastore.DockerRestore;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.docker.datastore.restore.DockerRestoreFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Singleton
@Named(value="v2")
public class DockerV2Restore
extends DockerV2RestoreSupport
implements DockerRestore {
    static final String NAME = "v2";
    private static final String BLOBS_PREFIX = "/v2/-/blobs/";
    private static final String CATALOG_NAME = "/v2/_catalog";
    private static final TokenParser manifestTokenParser = new TokenParser("/v2/{name:.+}/manifests/{tag}");
    private static final String TAG_LIST_PREFIX = "/v2";

    public DockerV2Restore() {
        super(manifestTokenParser, CATALOG_NAME, BLOBS_PREFIX, TAG_LIST_PREFIX);
    }

    @Override
    public void doRestore(Blob blob, DockerRestoreFacet facet, String blobName) {
        if (this.isBlob(blobName)) {
            facet.restoreV2Blob(blobName, blob);
        } else {
            Map<String, String> token = this.parseManifest(blobName);
            if (token != null) {
                facet.restoreV2Manifest(blobName, blob, token.get("name"));
            } else {
                token = this.parseManifestTag(blobName);
                if (token != null) {
                    facet.restoreV2Tag(blob, token.get("name"), token.get("tag"));
                } else if (this.isCatalog(blobName)) {
                    facet.restoreV2Catalog(blobName, blob);
                } else if (this.isTagList(blobName)) {
                    facet.restoreV2TagsList(blobName, blob);
                } else {
                    this.log.warn("Unable to determine the asset type for restore {}", (Object)blobName);
                }
            }
        }
    }

    @Override
    public boolean requiresComponent(String blobName) {
        return this.parseManifestTag(blobName) != null;
    }
}

