/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

public class DockerV2RestoreSupport
extends ComponentSupport {
    private TokenParser manifestTokenParser;
    private String catalogName;
    private String blobsPrefix;
    private String tagListPrefix;

    public DockerV2RestoreSupport(TokenParser manifestTokenParser, String catalogName, String blobsName, String tagListPrefix) {
        this.manifestTokenParser = manifestTokenParser;
        this.catalogName = catalogName;
        this.blobsPrefix = blobsName;
        this.tagListPrefix = tagListPrefix;
    }

    protected Map<String, String> parseManifest(String blobName) {
        Map parsedManifest = this.manifestTokenParser.parse(blobName);
        if (parsedManifest != null && parsedManifest.containsKey("name") && parsedManifest.containsKey("tag") && ((String)parsedManifest.get("tag")).contains(":")) {
            return parsedManifest;
        }
        return null;
    }

    protected Map<String, String> parseManifestTag(String blobName) {
        return this.manifestTokenParser.parse(blobName);
    }

    protected boolean isTagList(String blobName) {
        return blobName.startsWith(this.tagListPrefix) && blobName.endsWith("/tags/list");
    }

    protected boolean isCatalog(String blobName) {
        return this.catalogName.equals(blobName);
    }

    protected boolean isBlob(String blobName) {
        return blobName.startsWith(this.blobsPrefix);
    }
}

