/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

public class DockerV1RestoreSupport
extends ComponentSupport {
    protected static final String EXTENSION = "extension";
    protected static final String ID = "id";
    private TokenParser tagParser;
    private TokenParser tagsParser;
    private TokenParser layerMetadataParser;
    private TokenParser imagesTokenParser;

    protected DockerV1RestoreSupport(TokenParser tagParser, TokenParser tagsParser, TokenParser layerMetadataParser, TokenParser imagesTokenParser) {
        this.tagParser = tagParser;
        this.tagsParser = tagsParser;
        this.layerMetadataParser = layerMetadataParser;
        this.imagesTokenParser = imagesTokenParser;
    }

    protected Map<String, String> parseTag(String blobName) {
        return this.tagParser.parse(blobName);
    }

    protected boolean isTags(String blobName) {
        return this.tagsParser.parse(blobName) != null;
    }

    protected Map<String, String> parseLayerAncestry(String blobName) {
        Map parsed = this.layerMetadataParser.parse(blobName);
        if (parsed != null && this.isExtensionLayer((String)parsed.get(EXTENSION), "ancestry")) {
            return parsed;
        }
        return null;
    }

    protected Map<String, String> parseLayerContent(String blobName) {
        Map parsed = this.layerMetadataParser.parse(blobName);
        if (parsed != null && this.isExtensionLayer((String)parsed.get(EXTENSION), "layer")) {
            return parsed;
        }
        return null;
    }

    protected Map<String, String> parseLayerMetadata(String blobName) {
        Map parsed = this.layerMetadataParser.parse(blobName);
        if (parsed != null && !this.isExtensionLayer((String)parsed.get(EXTENSION), "layer", "ancestry")) {
            return parsed;
        }
        return null;
    }

    protected boolean isImages(String blobName) {
        return this.imagesTokenParser.parse(blobName) != null;
    }

    private boolean isExtensionLayer(String actualName, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(actualName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

