/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.osgi.NexusEdition;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionFeature;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionType;

public class ProStarterNexusEdition
extends NexusEdition {
    private static final Logger log = LoggerFactory.getLogger(ProStarterNexusEdition.class);

    @Override
    public NexusEditionType getEdition() {
        return NexusEditionType.PRO_STARTER;
    }

    @Override
    public NexusEditionFeature getEditionFeature() {
        return NexusEditionFeature.PRO_STARTER_FEATURE;
    }

    @Override
    protected boolean doesApply(Properties properties, Path workDirPath) {
        return !properties.getProperty("nexus-features", "").contains(NexusEditionFeature.OSS_FEATURE.featureString) && !this.shouldSwitchToOss(workDirPath);
    }

    @Override
    protected void doApply(Properties properties, Path workDirPath) {
        log.info("Loading Pro Starter Edition");
        properties.setProperty("nexus-edition", this.getEdition().editionString);
        properties.setProperty("nexus-features", this.getEditionFeature().featureString);
        properties.setProperty("nexus.analytics.enabled", Boolean.TRUE.toString());
        this.createEditionMarker(workDirPath, this.getEdition());
    }

    @Override
    protected boolean shouldSwitchToOss(Path workDirPath) {
        File proStarterEditionMarker = this.getEditionMarker(workDirPath, NexusEditionType.PRO_STARTER);
        boolean switchToOss = this.isNexusLoadAs("nexus.loadAsProStarter") && this.hasNexusLoadAs("nexus.loadAsProStarter") ? false : (this.hasNexusLoadAs("nexus.loadAsOSS") ? this.isNexusLoadAs("nexus.loadAsOSS") : (proStarterEditionMarker.exists() ? false : this.isNullNexusLicenseFile() && this.isNullJavaPrefLicensePath("/com/sonatype/nexus/pro-starter")));
        return switchToOss;
    }
}

