/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.osgi.NexusEdition;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionFeature;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionType;

public class ProNexusEdition
extends NexusEdition {
    private static final Logger log = LoggerFactory.getLogger(ProNexusEdition.class);

    @Override
    public NexusEditionType getEdition() {
        return NexusEditionType.PRO;
    }

    @Override
    public NexusEditionFeature getEditionFeature() {
        return NexusEditionFeature.PRO_FEATURE;
    }

    @Override
    protected boolean doesApply(Properties properties, Path workDirPath) {
        return !properties.getProperty("nexus-features", "").contains(NexusEditionFeature.OSS_FEATURE.featureString) && !properties.getProperty("nexus-features", "").contains(NexusEditionFeature.PRO_STARTER_FEATURE.featureString) && !this.shouldSwitchToOss(workDirPath);
    }

    @Override
    protected void doApply(Properties properties, Path workDirPath) {
        log.info("Loading Pro Edition");
        this.createEditionMarker(workDirPath, this.getEdition());
    }

    @Override
    protected boolean shouldSwitchToOss(Path workDirPath) {
        File proEditionMarker = this.getEditionMarker(workDirPath, NexusEditionType.PRO);
        boolean switchToOss = this.hasNexusLoadAs("nexus.loadAsOSS") ? this.isNexusLoadAs("nexus.loadAsOSS") : (this.hasNexusLoadAs("nexus.loadAsProStarter") ? this.isNexusLoadAs("nexus.loadAsProStarter") : (proEditionMarker.exists() ? false : this.isNullNexusLicenseFile() && this.isNullJavaPrefLicensePath("/com/sonatype/nexus/professional")));
        return switchToOss;
    }
}

