/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.osgi.NexusEdition;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionFeature;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionType;

public class OssNexusEdition
extends NexusEdition {
    private static final Logger log = LoggerFactory.getLogger(OssNexusEdition.class);

    @Override
    public NexusEditionType getEdition() {
        return NexusEditionType.OSS;
    }

    @Override
    public NexusEditionFeature getEditionFeature() {
        return NexusEditionFeature.OSS_FEATURE;
    }

    @Override
    protected boolean doesApply(Properties properties, Path workDirPath) {
        return true;
    }

    @Override
    protected void doApply(Properties properties, Path workDirPath) {
        log.info("Loading OSS Edition");
        properties.put("nexus-edition", NexusEditionType.OSS.editionString);
        String updatedNexusFeaturesProps = properties.getProperty("nexus-features").replace(NexusEditionFeature.PRO_FEATURE.featureString, this.getEditionFeature().featureString).replace(NexusEditionFeature.PRO_STARTER_FEATURE.featureString, this.getEditionFeature().featureString);
        properties.put("nexus-features", updatedNexusFeaturesProps);
    }

    @Override
    protected boolean shouldSwitchToOss(Path workDirPath) {
        return true;
    }
}

