/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import org.osgi.framework.Version;
import org.sonatype.nexus.bootstrap.internal.DirectoryHelper;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionFactory;

public class NexusEditionPropertiesConfigurer {
    static final String NEXUS_EDITION = "nexus-edition";
    static final String NEXUS_FULL_EDITION = "nexus-full-edition";
    static final String NEXUS_DB_FEATURE = "nexus-db-feature";
    private static final String NEXUS_EXCLUDE_FEATURES = "nexus-exclude-features";
    private static final Version ORIENT_MAX_JAVA_VERSION = new Version(11, 0, 0);

    public Properties getPropertiesFromConfiguration() throws IOException {
        Properties properties = System.getProperties();
        if (properties == null) {
            throw new IllegalStateException("Missing bootstrap configuration properties");
        }
        this.requireProperty(properties, "karaf.base");
        this.requireProperty(properties, "karaf.data");
        Path workDirPath = new File(properties.getProperty("karaf.data")).getCanonicalFile().toPath();
        DirectoryHelper.mkdir(workDirPath);
        NexusEditionFactory.selectActiveEdition(properties, workDirPath);
        this.selectDatastoreFeature(properties);
        this.selectAuthenticationFeature(properties);
        this.readEnvironmentVariables(properties);
        this.requireProperty(properties, NEXUS_EDITION);
        this.requireProperty(properties, NEXUS_DB_FEATURE);
        this.ensureHACIsDisabled();
        return properties;
    }

    private void readEnvironmentVariables(Properties properties) {
        if (properties.getProperty("nexus.change.repo.blobstore.task.enabled") == null) {
            properties.setProperty("nexus.change.repo.blobstore.task.enabled", Boolean.toString(Boolean.parseBoolean(System.getenv("CHANGE_REPO_BLOBSTORE_TASK_ENABLED"))));
        }
        if (properties.getProperty("nexus.firewall.quarantineFix.enabled") == null) {
            properties.setProperty("nexus.firewall.quarantineFix.enabled", Boolean.toString(Boolean.parseBoolean(System.getenv("FIREWALL_QUARANTINE_FIX_ENABLED"))));
        }
        if (properties.getProperty("nexus.zdu.baseline.fail") == null) {
            properties.setProperty("nexus.zdu.baseline.fail", Optional.ofNullable(System.getenv("NEXUS_ZDU_BASELINE_FAIL")).orElse("false"));
        }
    }

    private void selectDatastoreFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.developer", "false"))) {
            properties.setProperty("nexus.datastore.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.clustered.enabled", Optional.ofNullable(System.getenv("DATASTORE_CLUSTERED_ENABLED")).orElse("false")))) {
            properties.setProperty("nexus.datastore.clustered.enabled", "true");
            properties.setProperty("nexus.datastore.enabled", "true");
            properties.setProperty("nexus.datastore.table.search.enabled", "true");
            properties.setProperty("nexus.elasticsearch.enabled", "false");
            properties.setProperty("nexus.datastore.sql.cache.enabled", "true");
            properties.setProperty("nexus.jwt.enabled", "true");
            properties.setProperty("nexus.datastore.blobstore.metrics.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.table.search.enabled", "false"))) {
            properties.setProperty("nexus.datastore.enabled", "true");
            properties.setProperty("nexus.elasticsearch.enabled", "false");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.elasticsearch.enabled", "false"))) {
            properties.setProperty("nexus.datastore.table.search.enabled", "false");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.enabled", "false"))) {
            properties.setProperty("nexus.orient.enabled", "false");
            if (!Boolean.parseBoolean(properties.getProperty("nexus.datastore.developer", "false"))) {
                properties.setProperty(NEXUS_EXCLUDE_FEATURES, properties.getProperty(NEXUS_EXCLUDE_FEATURES, ""));
            }
        }
        this.selectDbFeature(properties);
    }

    private void selectDbFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.datastore.enabled", "false"))) {
            properties.setProperty(NEXUS_DB_FEATURE, "nexus-datastore-mybatis");
            properties.setProperty("nexus.change.repo.blobstore.task.enabled", "true");
            properties.setProperty("nexus.quartz.jobstore.jdbc", "true");
        } else {
            this.ensureOrientRunningWithCorrectJavaRuntime();
            properties.setProperty(NEXUS_DB_FEATURE, "nexus-orient");
            properties.setProperty("nexus.orient.enabled", "true");
        }
    }

    @VisibleForTesting
    void ensureOrientRunningWithCorrectJavaRuntime() {
        boolean versionAllowed;
        Version currentVersion = new Version(System.getProperty("java.version").replace("_", "."));
        boolean bl = versionAllowed = currentVersion.getMajor() <= ORIENT_MAX_JAVA_VERSION.getMajor();
        if (!versionAllowed) {
            throw new IllegalStateException("The maximum Java version for OrientDb is Java 11. Please check current Java version meets this requirement.");
        }
    }

    private void selectAuthenticationFeature(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("nexus.session.enabled", "true"))) {
            properties.setProperty("nexus.session.enabled", "true");
        }
        if (Boolean.parseBoolean(properties.getProperty("nexus.jwt.enabled", "false"))) {
            properties.setProperty("nexus.session.enabled", "false");
        }
    }

    private void requireProperty(Properties properties, String name) {
        if (!properties.containsKey(name)) {
            throw new IllegalStateException("Missing required property: " + name);
        }
    }

    @VisibleForTesting
    void ensureHACIsDisabled() {
        if (Boolean.getBoolean("nexus.clustered") || Boolean.parseBoolean(System.getenv("NEXUS_CLUSTERED"))) {
            throw new IllegalStateException("High Availability Clustering (HA-C) is a legacy feature and is no longer supported");
        }
    }
}

