/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.sonatype.nexus.bootstrap.osgi.NexusEdition;
import org.sonatype.nexus.bootstrap.osgi.OssNexusEdition;
import org.sonatype.nexus.bootstrap.osgi.ProNexusEdition;
import org.sonatype.nexus.bootstrap.osgi.ProStarterNexusEdition;

public class NexusEditionFactory {
    private static final List<NexusEdition> editions = ImmutableList.of((Object)new ProNexusEdition(), (Object)new ProStarterNexusEdition(), (Object)new OssNexusEdition());

    private NexusEditionFactory() {
        throw new IllegalStateException("NexusEditionFactory is a Utility class");
    }

    public static void selectActiveEdition(Properties properties, Path workDirPath) {
        NexusEdition nexusEdition = editions.stream().filter(edition -> edition.applies(properties, workDirPath)).findFirst().orElse(null);
        if (nexusEdition == null) {
            nexusEdition = new OssNexusEdition();
        }
        nexusEdition.apply(properties, workDirPath);
    }
}

