/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionFeature;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionType;

public abstract class NexusEdition {
    static final String NEXUS_EDITION = "nexus-edition";
    public static final String NEXUS_FEATURES = "nexus-features";
    private static final Logger log = LoggerFactory.getLogger(NexusEdition.class);
    public static final String NEXUS_LOAD_AS_OSS_PROP_NAME = "nexus.loadAsOSS";
    public static final String NEXUS_LOAD_AS_PRO_STARTER_PROP_NAME = "nexus.loadAsProStarter";
    private static final String EDITION_PRO_PATH = "edition_pro";
    private static final String EDITION_PRO_STARTER_PATH = "edition_pro_starter";
    public static final String PRO_LICENSE_LOCATION = "/com/sonatype/nexus/professional";
    public static final String PRO_STARTER_LICENSE_LOCATION = "/com/sonatype/nexus/pro-starter";

    public abstract NexusEditionType getEdition();

    public abstract NexusEditionFeature getEditionFeature();

    protected abstract boolean doesApply(Properties var1, Path var2);

    protected abstract void doApply(Properties var1, Path var2);

    protected abstract boolean shouldSwitchToOss(Path var1);

    public boolean applies(Properties properties, Path workDirPath) {
        return this.doesApply(properties, workDirPath);
    }

    public void apply(Properties properties, Path workDirPath) {
        this.doApply(properties, workDirPath);
    }

    protected boolean hasNexusLoadAs(String nexusProperty) {
        return System.getProperty(nexusProperty) != null;
    }

    public boolean isNexusLoadAs(String nexusProperty) {
        return Boolean.getBoolean(nexusProperty);
    }

    public boolean hasFeature(Properties properties, String feature) {
        return properties.getProperty(NEXUS_FEATURES, "").contains(feature);
    }

    protected boolean isNullNexusLicenseFile() {
        return System.getProperty("nexus.licenseFile") == null && System.getenv("NEXUS_LICENSE_FILE") == null;
    }

    protected boolean isNullJavaPrefLicensePath(String licensePath) {
        Thread currentThread = Thread.currentThread();
        ClassLoader tccl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            boolean bl = Preferences.userRoot().node(licensePath).get("license", null) == null;
            return bl;
        }
        finally {
            currentThread.setContextClassLoader(tccl);
        }
    }

    protected File getEditionMarker(Path workDirPath, NexusEditionType edition) {
        switch (edition) {
            case PRO: {
                return workDirPath.resolve(EDITION_PRO_PATH).toFile();
            }
            case PRO_STARTER: {
                return workDirPath.resolve(EDITION_PRO_STARTER_PATH).toFile();
            }
        }
        throw new IllegalStateException("Marker for OSS edition not supported!");
    }

    protected void createEditionMarker(Path workDirPath, NexusEditionType edition) {
        File editionMarker = this.getEditionMarker(workDirPath, edition);
        try {
            if (editionMarker.createNewFile()) {
                log.debug("Created {} edition marker file: {}", (Object)edition.name(), (Object)editionMarker);
            }
        }
        catch (IOException e) {
            log.error("Failed to create {}} edition marker file: {}", new Object[]{edition.name(), editionMarker, e});
        }
    }
}

