/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.osgi.FilterTracker;
import org.sonatype.nexus.bootstrap.osgi.ListenerTracker;
import org.sonatype.nexus.bootstrap.osgi.NexusEditionPropertiesConfigurer;

public class BootstrapListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(BootstrapListener.class);
    private ListenerTracker listenerTracker;
    private FilterTracker filterTracker;
    private final NexusEditionPropertiesConfigurer propertiesConfigurer = new NexusEditionPropertiesConfigurer();

    public void contextInitialized(ServletContextEvent event) {
        log.info("Initializing");
        ServletContext servletContext = event.getServletContext();
        try {
            Properties properties = this.propertiesConfigurer.getPropertiesFromConfiguration();
            servletContext.setAttribute("nexus.properties", (Object)properties);
            Bundle containingBundle = FrameworkUtil.getBundle(this.getClass());
            if (containingBundle == null) {
                throw new UnsupportedOperationException("Missing OSGi container");
            }
            BundleContext bundleContext = containingBundle.getBundleContext();
            BootstrapListener.installNexusEdition(bundleContext, properties);
            this.listenerTracker = new ListenerTracker(bundleContext, "nexus", servletContext);
            this.listenerTracker.open();
            this.filterTracker = new FilterTracker(bundleContext, "nexus");
            this.filterTracker.open();
            this.listenerTracker.waitForService(0L);
            this.filterTracker.waitForService(0L);
        }
        catch (Exception e) {
            log.error("Failed to initialize", (Throwable)e);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        log.info("Initialized");
    }

    private static void installNexusEdition(BundleContext ctx, Properties properties) throws Exception {
        String editionName = properties.getProperty("nexus-edition");
        if (editionName != null && !editionName.isEmpty()) {
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(ctx, FeaturesService.class, null);){
                FeaturesService featuresService = (FeaturesService)tracker.waitForService(1000L);
                Feature editionFeature = featuresService.getFeature(editionName);
                properties.put("nexus-full-edition", editionFeature.toString());
                Feature dbFeature = featuresService.getFeature(properties.getProperty("nexus-db-feature"));
                log.info("Installing: {} ({})", (Object)editionFeature, (Object)dbFeature);
                LinkedHashSet<String> featureIds = new LinkedHashSet<String>();
                if (!featuresService.isInstalled(editionFeature)) {
                    featureIds.add(editionFeature.getId());
                }
                if (!featuresService.isInstalled(dbFeature)) {
                    featureIds.add(dbFeature.getId());
                }
                if (!featureIds.isEmpty()) {
                    EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles, FeaturesService.Option.NoAutoRefreshManagedBundles);
                    featuresService.installFeatures(featureIds, options);
                }
                log.info("Installed: {} ({})", (Object)editionFeature, (Object)dbFeature);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.info("Destroying");
        if (this.filterTracker != null) {
            this.filterTracker.close();
            this.filterTracker = null;
        }
        if (this.listenerTracker != null) {
            this.listenerTracker.close();
            this.listenerTracker = null;
        }
        log.info("Destroyed");
    }
}

