/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.util.Map;
import java.util.logging.Handler;
import javax.annotation.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.nexus.bootstrap.ConfigurationBuilder;
import org.sonatype.nexus.bootstrap.internal.ShutdownHelper;
import org.sonatype.nexus.bootstrap.internal.TemporaryDirectory;
import org.sonatype.nexus.bootstrap.jetty.JettyServer;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class Launcher {
    private static final boolean HAS_JUL_BRIDGE;
    private static final boolean HAS_CONSOLE;
    private static final String LOGGING_OVERRIDE_PREFIX = "nexus.logging.level.";
    public static final String IGNORE_SHUTDOWN_HELPER;
    public static final String SYSTEM_USERID = "*SYSTEM";
    private final JettyServer server;

    static {
        boolean hasJulBridge;
        try {
            hasJulBridge = Handler.class.isAssignableFrom(SLF4JBridgeHandler.class);
        }
        catch (Exception | LinkageError throwable) {
            hasJulBridge = false;
        }
        HAS_JUL_BRIDGE = hasJulBridge;
        HAS_CONSOLE = Boolean.getBoolean("karaf.startLocalConsole");
        IGNORE_SHUTDOWN_HELPER = String.valueOf(ShutdownHelper.class.getName()) + ".ignore";
    }

    public Launcher(File defaultsFile, @Nullable File propertiesFile, @Nullable File nodeNamePropertiesFile) throws Exception {
        String args;
        this.configureLogging();
        ClassLoader cl = this.getClass().getClassLoader();
        ConfigurationBuilder builder = new ConfigurationBuilder().defaults();
        builder.properties(defaultsFile, true);
        builder.properties(propertiesFile, false);
        builder.properties(nodeNamePropertiesFile, "nexus.clustered.nodeName", false);
        builder.override(System.getProperties());
        Map<String, String> props = builder.build();
        System.getProperties().putAll(props);
        Logger log = LoggerFactory.getLogger(Launcher.class);
        if (log.isInfoEnabled()) {
            log.info("Java: {}, {}, {}, {}", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version")});
            log.info("OS: {}, {}, {}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
            log.info("User: {}, {}, {}", new Object[]{System.getProperty("user.name"), System.getProperty("user.language"), System.getProperty("user.home")});
            log.info("CWD: {}", (Object)System.getProperty("user.dir"));
        }
        File tmpdir = TemporaryDirectory.get();
        log.info("TMP: {}", (Object)tmpdir);
        if (!"false".equalsIgnoreCase(this.getProperty(IGNORE_SHUTDOWN_HELPER, "false"))) {
            log.warn("ShutdownHelper requests will be ignored!");
            ShutdownHelper.setDelegate(ShutdownHelper.NOOP);
        }
        if ((args = props.get("nexus-args")) == null || args.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing nexus-args");
        }
        this.configureInitialLoggingOverrides(props);
        this.server = new JettyServer(cl, props, args.split(","));
    }

    public JettyServer getServer() {
        return this.server;
    }

    public void start() throws Exception {
        this.start(true, null);
    }

    public void startAsync(@Nullable Runnable callback) throws Exception {
        this.start(false, callback);
    }

    private void start(boolean waitForServer, @Nullable Runnable callback) throws Exception {
        this.server.start(waitForServer, callback);
    }

    private String getProperty(String name, String defaultValue) {
        String value = System.getProperty(name, System.getenv(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private void configureLogging() {
        if (!HAS_CONSOLE) {
            SysOutOverSLF4J.registerLoggingSystem((String)"org.ops4j.pax.logging.slf4j");
            SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        }
        if (HAS_JUL_BRIDGE) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }

    private void configureInitialLoggingOverrides(Map<String, String> props) {
        LoggerContext loggerContext = this.loggerContext();
        if (props != null) {
            props.entrySet().stream().map(entry -> new Property((Map.Entry)entry)).filter(p -> ((Property)p).key.startsWith(LOGGING_OVERRIDE_PREFIX)).filter(p -> !((Property)p).value.isEmpty()).map(Property::access$3).forEach(p -> this.setLoggerLevel(loggerContext, ((Property)p).key, ((Property)p).value));
        }
    }

    private void setLoggerLevel(LoggerContext loggerContext, String logger, String level) {
        loggerContext.getLogger(Launcher.class).debug("Initialising logger: {} = {}", (Object)logger, (Object)level);
        loggerContext.getLogger(logger).setLevel(Level.valueOf((String)level));
    }

    private LoggerContext loggerContext() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            return (LoggerContext)factory;
        }
        return (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
    }

    private static class Property {
        private String key;
        private String value;

        private Property(Map.Entry<String, String> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        private Property withKeyPrefixRemoved() {
            if (Launcher.LOGGING_OVERRIDE_PREFIX.length() < this.key.length()) {
                this.key = this.key.substring(Launcher.LOGGING_OVERRIDE_PREFIX.length());
            }
            return this;
        }

        static /* synthetic */ Property access$3(Property property) {
            return property.withKeyPrefixRemoved();
        }
    }
}

