/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTask;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskConfiguration;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.RepositoryCombobox;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@AvailabilityVersion(from="1.0")
@Named
@Singleton
public class RepositoryMoveTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TASK_NAME = "Admin - Change repository blob store";
    public static final String TYPE_ID = "repository.move";
    public static final String REPOSITORY_NAME = "moveRepositoryName";
    public static final String SOURCE_BLOBSTORE_NAME = "moveInitialBlobstore";
    public static final String TARGET_BLOBSTORE_NAME = "moveTargetBlobstore";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreManager blobStoreManager;
    private final RepositoryManager repositoryManager;
    private final Provider<RepositoryMover> repositoryMoverProvider;
    private final ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore;
    private final List<RepositoryMoveTaskValidator> validators;
    private final boolean changeRepoBlobstoreTaskEnabled;

    @Inject
    public RepositoryMoveTaskDescriptor(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, NodeAccess nodeAccess, Provider<RepositoryMover> repositoryMoverProvider, ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore, List<RepositoryMoveTaskValidator> validators, @Named(value="${nexus.change.repo.blobstore.task.enabled:-false}") @Named(value="${nexus.change.repo.blobstore.task.enabled:-false}") boolean changeRepoBlobstoreTaskEnabled, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean datastoreClustered) {
        super(TYPE_ID, RepositoryMoveTask.class, messages.name(), true, true, true, new FormField[]{new RepositoryCombobox(REPOSITORY_NAME, messages.repositoryNameLabel(), messages.repositoryHelpText(), true), new ComboboxFormField(TARGET_BLOBSTORE_NAME, messages.blobstoreNameLabel(), messages.blobStoreHelpText(), true), nodeAccess.isClustered() && !datastoreClustered ? RepositoryMoveTaskDescriptor.newLimitNodeFormField() : null});
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryMoverProvider = (Provider)Preconditions.checkNotNull(repositoryMoverProvider);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.validators = (List)Preconditions.checkNotNull(validators);
        this.changeRepoBlobstoreTaskEnabled = changeRepoBlobstoreTaskEnabled;
    }

    public void initializeConfiguration(TaskConfiguration configuration) {
        configuration.setString("limitnode", "");
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isExposed() {
        return this.changeRepoBlobstoreTaskEnabled;
    }

    public TaskConfiguration createTaskConfiguration() {
        return new RepositoryMoveTaskConfiguration(this.repositoryManager, this.blobStoreManager, this.changeRepositoryBlobstoreStore, (RepositoryMover)this.repositoryMoverProvider.get(), this.validators);
    }

    public boolean allowConcurrentRun() {
        return false;
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Change repository blob store")
        public String name();

        @MessageBundle.DefaultMessage(value="Repository")
        public String repositoryNameLabel();

        @MessageBundle.DefaultMessage(value="Select a repository to change its blob store")
        public String repositoryHelpText();

        @MessageBundle.DefaultMessage(value="Destination blob store")
        public String blobstoreNameLabel();

        @MessageBundle.DefaultMessage(value="Select a blob store to move the repository to")
        public String blobStoreHelpText();
    }
}

