/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.List;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.scheduling.TaskConfiguration;

public class RepositoryMoveTaskConfiguration
extends TaskConfiguration {
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;
    private final ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore;
    private final RepositoryMover repositoryMover;
    private final List<RepositoryMoveTaskValidator> validators;

    public RepositoryMoveTaskConfiguration(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore, RepositoryMover repositoryMover, List<RepositoryMoveTaskValidator> validators) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.changeRepositoryBlobStoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobStoreStore);
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    public RepositoryMoveTaskConfiguration(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore, RepositoryMover repositoryMover, List<RepositoryMoveTaskValidator> validators, TaskConfiguration configuration) {
        this(repositoryManager, blobStoreManager, changeRepositoryBlobStoreStore, repositoryMover, validators);
        this.addAll(configuration.asMap());
    }

    public String getRepositoryName() {
        return this.getString("moveRepositoryName");
    }

    public String getSourceBlobStore() {
        return this.getString("moveInitialBlobstore");
    }

    public void setSourceBlobStore(String sourceBlobStoreName) {
        this.setString("moveInitialBlobstore", sourceBlobStoreName);
    }

    public String getTargetBlobStore() {
        return this.getString("moveTargetBlobstore");
    }

    public void validate() {
        super.validate();
        String repositoryName = this.getRepositoryName();
        String targetBlobStoreName = this.getTargetBlobStore();
        if (repositoryName == null) {
            throw new ValidationErrorsException("moveRepositoryName", "Repository name must not be null");
        }
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new ValidationErrorsException("moveRepositoryName", "Repository must not be null");
        }
        String sourceBlobStoreName = (String)this.repositoryManager.get(repositoryName).getConfiguration().attributes("storage").get("blobStoreName");
        if (sourceBlobStoreName == null) {
            throw new ValidationErrorsException("moveInitialBlobstore", "Source BlobStore name must not be null");
        }
        BlobStore sourceBlobStore = this.blobStoreManager.get(sourceBlobStoreName);
        if (sourceBlobStore == null) {
            throw new ValidationErrorsException("moveInitialBlobstore", "Source BlobStore must not be null");
        }
        if (targetBlobStoreName == null) {
            throw new ValidationErrorsException("moveTargetBlobstore", "Target BlobStore name must not be null");
        }
        BlobStore targetBlobStore = this.blobStoreManager.get(targetBlobStoreName);
        if (targetBlobStore == null) {
            throw new ValidationErrorsException("moveTargetBlobstore", "Target BlobStore must not be null");
        }
        if (!targetBlobStore.isStorageAvailable()) {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Target BlobStore %s does not have available storage", targetBlobStoreName));
        }
        if (!sourceBlobStore.isGroupable()) {
            throw new ValidationErrorsException("moveInitialBlobstore", String.format("Source BlobStore %s must not be promoted or a group", sourceBlobStoreName));
        }
        if (!targetBlobStore.isGroupable()) {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Target BlobStore %s must not be promoted or a group", targetBlobStoreName));
        }
        if (!targetBlobStore.isWritable()) {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Target BlobStore %s is not Writable", targetBlobStoreName));
        }
        this.blobStoreManager.getParent(sourceBlobStoreName).ifPresent(parentName -> {
            throw new ValidationErrorsException("moveInitialBlobstore", String.format("Source BlobStore %s must not be a member of a group (%s)", sourceBlobStoreName, parentName));
        });
        this.blobStoreManager.getParent(targetBlobStoreName).ifPresent(parentName -> {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Target BlobStore %s must not be a member of a group (%s)", targetBlobStoreName, parentName));
        });
        if (!this.repositoryMover.findMoveTasks(repositoryName, this.getId()).isEmpty()) {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Repository %s already has a move task created", repositoryName));
        }
        ChangeRepositoryBlobStoreConfiguration moveRecord = this.changeRepositoryBlobStoreStore.findByRepositoryName(repositoryName);
        if (moveRecord == null) {
            if (sourceBlobStoreName.equalsIgnoreCase(targetBlobStoreName)) {
                throw new ValidationErrorsException("moveTargetBlobstore", String.format("This task must have a target that differs from the current Repository BlobStore (%s)", sourceBlobStoreName));
            }
        } else if (!targetBlobStoreName.equalsIgnoreCase(moveRecord.getTargetBlobStoreName()) && !targetBlobStoreName.equalsIgnoreCase(moveRecord.getSourceBlobStoreName())) {
            throw new ValidationErrorsException("moveTargetBlobstore", String.format("Repository %s already has a Move Task started and not yet completed", repositoryName));
        }
        for (RepositoryMoveTaskValidator validator : this.validators) {
            validator.validate(this);
        }
        this.setSourceBlobStore(sourceBlobStoreName);
    }
}

