/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskConfiguration;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTaskValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.scheduling.TaskUtils;

@Named
public class RepositoryMoveTask
extends TaskSupport
implements Cancelable {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final RepositoryMover repositoryMover;
    private final int delaySecondsBeforeCleanup;
    private final TaskUtils taskUtils;
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;
    private final ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore;
    private final List<RepositoryMoveTaskValidator> validators;

    @Inject
    public RepositoryMoveTask(RepositoryMover repositoryMover, @Named(value="${nexus.repository.move.delaySecondsBeforeCleanup:-30}") @Named(value="${nexus.repository.move.delaySecondsBeforeCleanup:-30}") int delaySecondsBeforeCleanup, TaskUtils taskUtils, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobStoreStore, List<RepositoryMoveTaskValidator> validators) {
        this.repositoryMover = (RepositoryMover)Preconditions.checkNotNull((Object)repositoryMover);
        this.delaySecondsBeforeCleanup = delaySecondsBeforeCleanup;
        this.taskUtils = (TaskUtils)Preconditions.checkNotNull((Object)taskUtils);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.changeRepositoryBlobStoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobStoreStore);
        this.validators = (List)Preconditions.checkNotNull(validators);
    }

    @VisibleForTesting
    void checkForConflicts() {
        String sourceBlobStore = this.getConfiguration().getString("moveInitialBlobstore");
        String targetBlobStore = this.getConfiguration().getString("moveTargetBlobstore");
        ImmutableMap conflictingConfig = ImmutableMap.of((Object)"fromGroup", Arrays.asList(targetBlobStore, sourceBlobStore), (Object)"memberToRemove", Arrays.asList(targetBlobStore, sourceBlobStore), (Object)"blobstoreName", Arrays.asList(sourceBlobStore, targetBlobStore));
        this.taskUtils.checkForConflictingTasks(this.getId(), this.getName(), Arrays.asList("blobstore.group.memberRemoval", "blobstore.rebuildComponentDB", "blobstore.compact"), (Map)conflictingConfig);
    }

    protected Object execute() throws Exception {
        this.checkForConflicts();
        RepositoryMoveTaskConfiguration configuration = new RepositoryMoveTaskConfiguration(this.repositoryManager, this.blobStoreManager, this.changeRepositoryBlobStoreStore, this.repositoryMover, this.validators, this.taskConfiguration());
        String repositoryName = configuration.getRepositoryName();
        String targetBlobStoreName = configuration.getTargetBlobStore();
        String initialBlobStoreName = configuration.getSourceBlobStore();
        for (RepositoryMoveTaskValidator validator : this.validators) {
            validator.validate(configuration);
        }
        this.repositoryMover.validateRepositoryMove(repositoryName, initialBlobStoreName, targetBlobStoreName);
        this.repositoryMover.updateRepositoryBlobstoreConfiguration(repositoryName, targetBlobStoreName);
        this.repositoryMover.initialize(repositoryName, initialBlobStoreName, targetBlobStoreName);
        this.repositoryMover.moveBlobs(this, repositoryName, initialBlobStoreName, false);
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Waiting {} seconds before cleanup phase", (Object)this.delaySecondsBeforeCleanup);
        TimeUnit.SECONDS.sleep(this.delaySecondsBeforeCleanup);
        this.repositoryMover.moveBlobs(this, repositoryName, initialBlobStoreName, true);
        this.getConfiguration().setString("moveInitialBlobstore", "-1");
        this.repositoryMover.cleanup(repositoryName);
        return null;
    }

    public String getMessage() {
        return messages.message();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Run repository blobstore move task")
        public String message();
    }
}

