/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.storage;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.tasks.BlobStoreConsumer;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;

@Singleton
@Named
public class ChangeBlobStoreTaskBlobStoreConsumer
extends ComponentSupport
implements BlobStoreConsumer {
    final ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore;

    @Inject
    public ChangeBlobStoreTaskBlobStoreConsumer(ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore) {
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
    }

    public boolean isBlobStoreInUse(String blobStoreName) {
        List runningChangeRepositoryTasks = this.changeRepositoryBlobstoreStore.findByBlobStoreName(blobStoreName);
        this.logDetails(runningChangeRepositoryTasks, blobStoreName);
        return runningChangeRepositoryTasks != null && runningChangeRepositoryTasks.size() > 0;
    }

    public int blobStoreUsageCount(String blobStoreName) {
        List runningChangeRepositoryTasks = this.changeRepositoryBlobstoreStore.findByBlobStoreName(blobStoreName);
        this.logDetails(runningChangeRepositoryTasks, blobStoreName);
        return runningChangeRepositoryTasks == null ? 0 : runningChangeRepositoryTasks.size();
    }

    private void logDetails(List<ChangeRepositoryBlobStoreConfiguration> runningTasks, String blobStoreName) {
        if (runningTasks != null && !runningTasks.isEmpty()) {
            this.log.warn("found {} change blobstore task(s) currently using the blobstore '{}'", (Object)runningTasks.size(), (Object)blobStoreName);
        }
    }
}

