/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal.storage.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.repository.move.internal.storage.orient.ChangeRepositoryBlobStoreConfigurationImpl;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;

@FeatureFlag(name="nexus.orient.enabled")
@Named
@Singleton
public class ChangeRepositoryBlobstoreEntityAdapter
extends IterableEntityAdapter<ChangeRepositoryBlobStoreConfigurationImpl> {
    static final String P_REPOSITORY_NAME = "repository_name";
    static final String P_TARGET_BLOBSTORE_NAME = "target_blobstore_name";
    static final String P_SOURCE_BLOBSTORE_NAME = "source_blobstore_name";
    static final String P_PROCESS_START_DATE = "process_start";
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"repository_name"});
    private static final String DB_CLASS = new OClassNameBuilder().type("change_repo_blobstore").build();
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").build();
    private static final String REPOSITORY_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "repository_name");
    private static final String BLOBSTORE_QUERY = String.format("SELECT FROM %s WHERE %s = ? OR %s = ?", DB_CLASS, "target_blobstore_name", "source_blobstore_name");

    public ChangeRepositoryBlobstoreEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_TARGET_BLOBSTORE_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_SOURCE_BLOBSTORE_NAME, OType.STRING).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createProperty(P_PROCESS_START_DATE, OType.DATETIME).setCollate((OCollate)new OCaseInsensitiveCollate()).setMandatory(true).setNotNull(true);
        type.createIndex(I_REPOSITORY_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME});
    }

    protected ChangeRepositoryBlobStoreConfigurationImpl newEntity() {
        return new ChangeRepositoryBlobStoreConfigurationImpl();
    }

    protected void readFields(ODocument document, ChangeRepositoryBlobStoreConfigurationImpl entity) throws Exception {
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        String targetBlobstoreName = (String)document.field(P_TARGET_BLOBSTORE_NAME, OType.STRING);
        String sourceBlobstoreName = (String)document.field(P_SOURCE_BLOBSTORE_NAME, OType.STRING);
        Calendar processStartDate = Calendar.getInstance();
        processStartDate.setTime((Date)document.field(P_PROCESS_START_DATE, OType.DATETIME));
        entity.setName(repositoryName);
        entity.setTargetBlobStoreName(targetBlobstoreName);
        entity.setSourceBlobStoreName(sourceBlobstoreName);
        entity.setStarted(OffsetDateTime.from(processStartDate.toInstant().atOffset(ZoneOffset.UTC)));
    }

    protected void writeFields(ODocument document, ChangeRepositoryBlobStoreConfigurationImpl entity) throws Exception {
        document.field(P_REPOSITORY_NAME, (Object)entity.getName());
        document.field(P_TARGET_BLOBSTORE_NAME, (Object)entity.getTargetBlobStoreName());
        document.field(P_SOURCE_BLOBSTORE_NAME, (Object)entity.getSourceBlobStoreName());
        document.field(P_PROCESS_START_DATE, (Object)new Date(entity.getStarted().toEpochSecond()));
    }

    @Nullable
    public ChangeRepositoryBlobStoreConfigurationImpl selectByRepoName(ODatabaseDocumentTx db, String repositoryName) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)repositoryName);
        OSQLSynchQuery query = new OSQLSynchQuery(REPOSITORY_QUERY);
        List results = (List)db.command((OCommandRequest)query).execute(new Object[]{repositoryName});
        if (!results.isEmpty()) {
            return (ChangeRepositoryBlobStoreConfigurationImpl)this.readEntity((OIdentifiable)results.get(0));
        }
        return null;
    }

    @Nullable
    public List<ChangeRepositoryBlobStoreConfiguration> selectByBlobstoreName(ODatabaseDocumentTx db, String blobstoreName) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)blobstoreName);
        OSQLSynchQuery query = new OSQLSynchQuery(BLOBSTORE_QUERY);
        List results = (List)db.command((OCommandRequest)query).execute(new Object[]{blobstoreName, blobstoreName});
        if (!results.isEmpty()) {
            return results.stream().map(oDoc -> (ChangeRepositoryBlobStoreConfigurationImpl)this.readEntity((OIdentifiable)oDoc)).collect(Collectors.toList());
        }
        return null;
    }

    public boolean delete(ODatabaseDocumentTx db, String repositoryName) {
        return this.delete.execute(db, new Object[]{repositoryName});
    }
}

