/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal.storage.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.repository.move.internal.storage.orient.ChangeRepositoryBlobStoreConfigurationImpl;
import com.sonatype.nexus.repository.move.internal.storage.orient.ChangeRepositoryBlobstoreEntityAdapter;
import java.time.OffsetDateTime;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class ChangeRepositoryBlobStoreStoreImpl
extends StateGuardLifecycleSupport
implements ChangeRepositoryBlobStoreStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final ChangeRepositoryBlobstoreEntityAdapter entityAdapter;

    @Inject
    public ChangeRepositoryBlobStoreStoreImpl(@Named(value="component") @Named(value="component") Provider<DatabaseInstance> databaseInstance, ChangeRepositoryBlobstoreEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (ChangeRepositoryBlobstoreEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public ChangeRepositoryBlobStoreConfiguration findByRepositoryName(String repository) {
        return (ChangeRepositoryBlobStoreConfiguration)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.selectByRepoName(db, repository));
    }

    @Nullable
    public List<ChangeRepositoryBlobStoreConfiguration> findByBlobStoreName(String blobStoreName) {
        return (List)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.selectByBlobstoreName(db, blobStoreName));
    }

    @Guarded(by={"STARTED"})
    public List<ChangeRepositoryBlobStoreConfiguration> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Guarded(by={"STARTED"})
    public void create(ChangeRepositoryBlobStoreConfiguration configuration) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((ChangeRepositoryBlobStoreConfigurationImpl)configuration));
        });
    }

    @Guarded(by={"STARTED"})
    public void add(String repository, String sourceBlobStoreName, String targetBlobStoreName) {
        ChangeRepositoryBlobStoreConfiguration existing = this.findByRepositoryName(repository);
        if (existing != null) {
            throw new RuntimeException(String.format("cannot start task to move repository %s from blobstore %s to blobstore %s, another task has been started to move it from blobstore %s to blobstore %s", repository, sourceBlobStoreName, targetBlobStoreName, existing.getSourceBlobStoreName(), existing.getTargetBlobStoreName()));
        }
        ChangeRepositoryBlobStoreConfigurationImpl config = new ChangeRepositoryBlobStoreConfigurationImpl();
        config.setName(repository);
        config.setSourceBlobStoreName(sourceBlobStoreName);
        config.setTargetBlobStoreName(targetBlobStoreName);
        config.setStarted(OffsetDateTime.now());
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)config);
        });
    }

    public void update(String repository, String sourceBlobStoreName, String targetBlobStoreName) {
        ChangeRepositoryBlobStoreConfigurationImpl existing = (ChangeRepositoryBlobStoreConfigurationImpl)this.findByRepositoryName(repository);
        if (existing == null) {
            throw new RuntimeException(String.format("cannot find record for repository %s to update.", repository));
        }
        existing.setSourceBlobStoreName(sourceBlobStoreName);
        existing.setTargetBlobStoreName(targetBlobStoreName);
        existing.setStarted(OffsetDateTime.now());
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)existing);
        });
    }

    @Guarded(by={"STARTED"})
    public void remove(String repository) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.delete(db, repository);
        });
    }
}

