/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal.storage;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.move.internal.storage.ChangeRepositoryBlobStoreData;
import com.sonatype.nexus.repository.move.internal.storage.ChangeRepositoryBlobstoreDAO;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class ChangeRepositoryBlobStoreStoreImpl
extends ConfigStoreSupport<ChangeRepositoryBlobstoreDAO>
implements ChangeRepositoryBlobStoreStore {
    @Inject
    public ChangeRepositoryBlobStoreStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public List<ChangeRepositoryBlobStoreConfiguration> list() {
        return ImmutableList.copyOf((Iterable)((ChangeRepositoryBlobstoreDAO)this.dao()).browse());
    }

    @Transactional
    public void create(ChangeRepositoryBlobStoreConfiguration configuration) {
        ((ChangeRepositoryBlobstoreDAO)this.dao()).create((ChangeRepositoryBlobStoreData)configuration);
    }

    @Nullable
    @Transactional
    public ChangeRepositoryBlobStoreConfiguration findByRepositoryName(String repository) {
        return ((ChangeRepositoryBlobstoreDAO)this.dao()).read(repository).orElse(null);
    }

    @Transactional
    public List<ChangeRepositoryBlobStoreConfiguration> findByBlobStoreName(String blobStoreName) {
        return StreamSupport.stream(((ChangeRepositoryBlobstoreDAO)this.dao()).findByBlobstoreName(blobStoreName).spliterator(), false).collect(Collectors.toList());
    }

    @Transactional
    public void add(String repository, String sourceBlobStoreName, String targetBlobStoreName) {
        ChangeRepositoryBlobStoreData data = new ChangeRepositoryBlobStoreData();
        data.setName(repository);
        data.setSourceBlobStoreName(sourceBlobStoreName);
        data.setTargetBlobStoreName(targetBlobStoreName);
        data.setStarted(OffsetDateTime.now());
        ((ChangeRepositoryBlobstoreDAO)this.dao()).create(data);
    }

    @Transactional
    public void update(String repository, String sourceBlobStoreName, String targetBlobStoreName) {
        ChangeRepositoryBlobStoreData data = new ChangeRepositoryBlobStoreData();
        data.setName(repository);
        data.setSourceBlobStoreName(sourceBlobStoreName);
        data.setTargetBlobStoreName(targetBlobStoreName);
        data.setStarted(OffsetDateTime.now());
        ((ChangeRepositoryBlobstoreDAO)this.dao()).update(data);
    }

    @Transactional
    public void remove(String repository) {
        ((ChangeRepositoryBlobstoreDAO)this.dao()).delete(repository);
    }
}

