/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.internal.MoveBlobService;
import com.sonatype.nexus.repository.move.internal.RepositoryMoverSupport;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.transaction.UnitOfWork;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="orient")
@Singleton
public class PagingRepositoryMover
extends RepositoryMoverSupport
implements RepositoryMover {
    private static final int BUCKET_KEY_ID = 0;
    private final AssetStore assetStore;
    private final BucketStore bucketStore;
    private final NodeAccess nodeAccess;
    private final BlobStoreManager blobStoreManager;

    @Inject
    public PagingRepositoryMover(AssetStore assetStore, BucketStore bucketStore, BlobStoreManager blobStoreManager, RepositoryManager repositoryManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore, TaskScheduler taskScheduler, MoveBlobService moveBlobService, NodeAccess nodeAccess) {
        super(repositoryManager, blobStoreManager, changeRepositoryBlobstoreStore, taskScheduler, moveBlobService);
        this.assetStore = (AssetStore)Preconditions.checkNotNull((Object)assetStore);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @Override
    public List<TaskInfo> findMoveTasks(String repositoryName, String taskId) {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        UnitOfWork paused = UnitOfWork.pause();
        try {
            List<TaskInfo> list = super.findMoveTasks(repositoryName, taskId);
            return list;
        }
        finally {
            UnitOfWork.resume((UnitOfWork)paused);
            if (db != null) {
                db.activateOnCurrentThread();
            }
        }
    }

    @Override
    public void moveBlobs(RepositoryMoveTask caller, String repositoryName, String sourceBlobStoreName, boolean quiet) {
        OIndexCursor cursor = this.assetStore.getIndex(AssetEntityAdapter.I_BUCKET_COMPONENT_NAME).cursor();
        int currentPage = 0;
        long totalAssets = this.countAssets(repositoryName);
        int processed = 16;
        while (processed >= 0) {
            processed = this.movePageOfBlobs(repositoryName, sourceBlobStoreName, cursor, caller, totalAssets, currentPage++, quiet);
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Processed {} blobs", (Object)processed);
        }
    }

    private int movePageOfBlobs(String repoName, String sourceBlobStoreName, OIndexCursor cursor, TaskSupport caller, long totalAssets, int currentPage, boolean quiet) {
        this.checkContinuation(caller, repoName);
        Bucket bucket = this.bucketStore.read(repoName);
        Repository repo = this.getRepositoryManager().get(repoName);
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Attempted to move Blobs from Repository %s but no such Repository found", repoName));
        }
        ORID bucketId = AttachedEntityHelper.id((Entity)bucket);
        List nextPage = this.assetStore.getNextPage(cursor, 16);
        List<Asset> assets = this.getAssetsFromPage(nextPage, bucketId);
        boolean lastPage = nextPage.size() < 16;
        HashMap<BlobId, Asset> blobIdAssets = new HashMap<BlobId, Asset>();
        BlobStore source = this.blobStoreManager.get(sourceBlobStoreName);
        if (source == null) {
            throw new IllegalArgumentException(String.format("Attempted to move page of blobs from BlobStore %s but no such store found", sourceBlobStoreName));
        }
        for (Asset asset : assets) {
            BlobId blobId;
            BlobRef blobRef = asset.blobRef();
            if (blobRef == null || (blobId = blobRef.getBlobId()) == null || !source.exists(blobId)) continue;
            blobIdAssets.put(blobId, asset);
        }
        ArrayList<BlobId> blobIds = new ArrayList<BlobId>(blobIdAssets.keySet());
        String targetBlobStore = (String)repo.getConfiguration().attributes("storage").get("blobStoreName", String.class);
        List<Blob> movedBlobs = this.moveBlobIds(sourceBlobStoreName, targetBlobStore, blobIds, caller.getName(), totalAssets, currentPage, quiet);
        movedBlobs.forEach(movedBlob -> {
            Asset assetToUpdate = (Asset)blobIdAssets.get(movedBlob.getId());
            assetToUpdate.blobRef(new BlobRef(this.nodeAccess.getId(), targetBlobStore, movedBlob.getId().asUniqueString()));
            this.assetStore.save(assetToUpdate);
        });
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Processed {} records", (Object)blobIds.size());
        if (lastPage) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "No more blobs found in {}", (Object)repoName);
            return -1;
        }
        return blobIds.size();
    }

    @VisibleForTesting
    protected List<Asset> getAssetsFromPage(List<Map.Entry<OCompositeKey, EntityId>> page, ORID bucketId) {
        ArrayList<Asset> assets = new ArrayList<Asset>(page.size());
        for (Map.Entry<OCompositeKey, EntityId> indexEntry : page) {
            if (!bucketId.equals(indexEntry.getKey().getKeys().get(0))) continue;
            Asset asset = this.assetStore.getById(indexEntry.getValue());
            if (asset != null) {
                assets.add(this.assetStore.getById(indexEntry.getValue()));
                continue;
            }
            this.log.warn("Unable to load paged asset record from store for index key {}, ignoring and moving on to next record.", (Object)indexEntry.getKey());
        }
        return assets;
    }

    private long countAssets(String repositoryName) {
        Bucket bucket = this.bucketStore.read(repositoryName);
        ArrayList<Bucket> repoBuckets = new ArrayList<Bucket>();
        repoBuckets.add(bucket);
        return this.assetStore.countAssets(repoBuckets);
    }
}

