/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.RepositoryMover;
import com.sonatype.nexus.repository.move.internal.MoveBlobService;
import java.util.List;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskSupport;

public abstract class RepositoryMoverSupport
extends ComponentSupport
implements RepositoryMover {
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;
    private final ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore;
    private final TaskScheduler taskScheduler;
    private final MoveBlobService moveBlobService;

    public RepositoryMoverSupport(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore, TaskScheduler taskScheduler, MoveBlobService moveBlobService) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.changeRepositoryBlobstoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.moveBlobService = (MoveBlobService)((Object)Preconditions.checkNotNull((Object)((Object)moveBlobService)));
    }

    @Override
    public void initialize(String repositoryName, String sourceBlobStoreName, String targetBlobStoreName) {
        this.addOrUpdateRepositoryChangeStore(repositoryName, sourceBlobStoreName, targetBlobStoreName);
    }

    @Override
    public void cleanup(String repositoryName) {
        this.clearRepositoryChangeStore(repositoryName);
    }

    private void addOrUpdateRepositoryChangeStore(String repositoryName, String sourceBlobstore, String targetBlobstore) {
        ChangeRepositoryBlobStoreConfiguration config = this.changeRepositoryBlobstoreStore.findByRepositoryName(repositoryName);
        if (config == null) {
            this.changeRepositoryBlobstoreStore.add(repositoryName, sourceBlobstore, targetBlobstore);
        } else {
            this.changeRepositoryBlobstoreStore.update(repositoryName, sourceBlobstore, targetBlobstore);
        }
    }

    private void clearRepositoryChangeStore(String repositoryName) {
        this.changeRepositoryBlobstoreStore.remove(repositoryName);
    }

    @Override
    public void updateRepositoryBlobstoreConfiguration(String repositoryName, String targetBlobStoreName) {
        Configuration repositoryConfiguration = this.getRepositoryConfiguration(repositoryName);
        String oldBlobStoreName = (String)repositoryConfiguration.attributes("storage").get("blobStoreName");
        repositoryConfiguration.attributes("storage").set("blobStoreName", (Object)targetBlobStoreName);
        this.log.info("Changing repository blob storage: {} from {} to {}", new Object[]{repositoryName, oldBlobStoreName, targetBlobStoreName});
        this.updateRepositoryConfiguration(repositoryName, repositoryConfiguration);
        this.log.debug("BlobStore updated");
    }

    @Override
    public void validateRepositoryMove(String repositoryName, String sourceBlobStoreName, String targetBlobStoreName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new IllegalArgumentException("Repository " + repositoryName + " is not available.");
        }
        if (sourceBlobStoreName == null) {
            throw new IllegalStateException("The move has already completed");
        }
        if (targetBlobStoreName == null) {
            throw new IllegalArgumentException("Repository " + repositoryName + " does not have a blobstore configuration.");
        }
        if (this.blobStoreManager.get(sourceBlobStoreName) == null) {
            throw new IllegalArgumentException("Blobstore " + sourceBlobStoreName + " is not available.");
        }
        if (this.blobStoreManager.get(targetBlobStoreName) == null) {
            throw new IllegalArgumentException("Blobstore " + targetBlobStoreName + " is not available.");
        }
        if (sourceBlobStoreName.equals(targetBlobStoreName)) {
            throw new IllegalArgumentException("repository is already using blobstore " + sourceBlobStoreName);
        }
    }

    @Override
    public List<TaskInfo> findMoveTasks(String repositoryName, String taskId) {
        return this.taskScheduler.listsTasks().stream().filter(taskInfo -> (taskId == null || !taskId.equals(taskInfo.getId())) && taskInfo.getTypeId().equals("repository.move") && repositoryName.equals(taskInfo.getConfiguration().getString("moveRepositoryName"))).collect(Collectors.toList());
    }

    private void updateRepositoryConfiguration(String repositoryName, Configuration repositoryConfiguration) {
        try {
            this.repositoryManager.update(repositoryConfiguration);
        }
        catch (Exception e) {
            this.log.error("Unable to update the repository {} configuration", (Object)repositoryName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Configuration getRepositoryConfiguration(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        return repository.getConfiguration().copy();
    }

    protected void checkContinuation(TaskSupport caller, String repoName) {
        if (caller.isCanceled()) {
            throw new TaskInterruptedException(String.format("Moving blobs off repository %s was cancelled", repoName), true);
        }
    }

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    protected List<Blob> moveBlobIds(String sourceBlobStore, String targetBlobStore, List<BlobId> blobIds, String taskName, long totalAssets, int currentPage, boolean quiet) {
        return this.moveBlobService.moveBlobIds(sourceBlobStore, targetBlobStore, blobIds, taskName, totalAssets, currentPage, quiet);
    }
}

