/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.move.internal.MoveBlobService;
import com.sonatype.nexus.repository.move.internal.RepositoryMoverSupport;
import com.sonatype.nexus.repository.move.tasks.RepositoryMoveTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.store.AssetBlobStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskSupport;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class RepositoryMoverImpl
extends RepositoryMoverSupport {
    private static final int PAGE_SIZE = 16;
    private final BlobStoreUtil blobStoreUtil;
    private final BlobStoreManager blobStoreManager;
    private final Map<String, FormatStoreManager> formatStoreManagers;

    @Inject
    public RepositoryMoverImpl(RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore, TaskScheduler taskScheduler, MoveBlobService moveBlobService, BlobStoreUtil blobStoreUtil, Map<String, FormatStoreManager> formatStoreManagers) {
        super(repositoryManager, blobStoreManager, changeRepositoryBlobstoreStore, taskScheduler, moveBlobService);
        this.blobStoreUtil = (BlobStoreUtil)Preconditions.checkNotNull((Object)blobStoreUtil);
        this.formatStoreManagers = (Map)Preconditions.checkNotNull(formatStoreManagers);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @Override
    public void moveBlobs(RepositoryMoveTask caller, String repositoryName, String sourceBlobStoreName, boolean quiet) {
        Repository repository = this.getRepositoryManager().get(repositoryName);
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Attempted to move Blobs from Repository %s but no such Repository found", repositoryName));
        }
        AssetBlobStore<?> assetBlobStore = this.getAssetBlobStore(repository);
        FluentAssets fluentAssets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        Continuation page = fluentAssets.browse(16, null);
        int currentPage = 0;
        int totalAssets = fluentAssets.count();
        while (!page.isEmpty()) {
            this.movePageOfBlobs((Continuation<FluentAsset>)page, repository, sourceBlobStoreName, assetBlobStore, caller, totalAssets, currentPage++, quiet);
            String token = page.nextContinuationToken();
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Processed {} blobs, continuation {}", (Object)page.size(), (Object)token);
            if (token == null) break;
            page = fluentAssets.browse(16, token);
        }
    }

    private AssetBlobStore<?> getAssetBlobStore(Repository repository) {
        String format = repository.getFormat().getValue();
        String contentStore = (String)repository.getConfiguration().attributes("storage").get("dataStoreName", String.class, (Object)"nexus");
        FormatStoreManager formatStoreManager = this.formatStoreManagers.get(format);
        return formatStoreManager.assetBlobStore(contentStore);
    }

    private void movePageOfBlobs(Continuation<FluentAsset> fluentAssets, Repository repository, String sourceBlobStoreName, AssetBlobStore<?> assetBlobStore, TaskSupport caller, long totalAssets, int currentPage, boolean quiet) {
        this.checkContinuation(caller, repository.getName());
        HashMap blobIdAssets = new HashMap();
        HashMap blobRefs = new HashMap();
        BlobStore source = this.blobStoreManager.get(sourceBlobStoreName);
        if (source == null) {
            throw new IllegalArgumentException(String.format("Attempted to move page of blobs from BlobStore %s but no such store found", sourceBlobStoreName));
        }
        fluentAssets.forEach(fluentAsset -> fluentAsset.blob().map(AssetBlob::blobRef).filter(blobRef -> this.isBlobRefValidAndInBlobStore(source, (BlobRef)blobRef)).ifPresent(blobRef -> {
            blobIdAssets.put(blobRef.getBlobId(), fluentAsset);
            blobRefs.put(blobRef.getBlobId(), blobRef);
        }));
        ArrayList<BlobId> blobIds = new ArrayList<BlobId>(blobIdAssets.keySet());
        List<Blob> movedBlobs = this.moveBlobIds(sourceBlobStoreName, (String)repository.getConfiguration().attributes("storage").get("blobStoreName", String.class), blobIds, caller.getName(), totalAssets, currentPage, quiet);
        movedBlobs.forEach(movedBlob -> {
            BlobId movedBlobId = movedBlob.getId();
            FluentAsset assetToUpdate = (FluentAsset)blobIdAssets.get(movedBlobId);
            Optional assetBlob = assetToUpdate.blob();
            Map checksums = assetBlob.isPresent() ? ((AssetBlob)assetBlob.get()).checksums() : Collections.emptyMap();
            assetToUpdate.attachIgnoringWritePolicy(movedBlob, this.blobStoreUtil.toHashObjects(checksums));
            assetBlobStore.deleteAssetBlob((BlobRef)blobRefs.get(movedBlobId));
        });
    }

    private boolean isBlobRefValidAndInBlobStore(BlobStore blobStore, BlobRef blobRef) {
        return blobStore.getBlobStoreConfiguration().getName().equals(blobRef.getStore()) && blobStore.get(blobRef.getBlobId()) != null;
    }
}

