/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.move.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreConfiguration;
import org.sonatype.nexus.repository.move.ChangeRepositoryBlobStoreStore;
import org.sonatype.nexus.repository.move.RepositoryMoveService;

@Singleton
@Named
public class RepositoryMoveServiceImpl
extends ComponentSupport
implements RepositoryMoveService {
    private final BlobStoreManager blobStoreManager;
    private final ChangeRepositoryBlobStoreStore changeBlobstoreStore;

    @Inject
    public RepositoryMoveServiceImpl(BlobStoreManager blobStoreManager, ChangeRepositoryBlobStoreStore changeRepositoryBlobstoreStore) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.changeBlobstoreStore = (ChangeRepositoryBlobStoreStore)Preconditions.checkNotNull((Object)changeRepositoryBlobstoreStore);
    }

    public Blob getIfBeingMoved(BlobRef blobRef, String sourceRepositoryName) {
        this.log.debug("Checking if repository '{}' is involved in any move processes", (Object)sourceRepositoryName);
        ChangeRepositoryBlobStoreConfiguration existingMove = this.changeBlobstoreStore.findByRepositoryName(sourceRepositoryName);
        if (existingMove != null) {
            try {
                this.log.debug("Found move process in progress for repository '{}', from blobstore '{}' to '{}'", new Object[]{existingMove.getName(), existingMove.getSourceBlobStoreName(), existingMove.getTargetBlobStoreName()});
                String source = existingMove.getSourceBlobStoreName();
                this.log.debug("Checking if blobstore '{}' has {}", (Object)source, (Object)blobRef.getBlobId());
                BlobStore blobStore = this.blobStoreManager.get(source);
                Blob blob = blobStore.get(blobRef.getBlobId());
                if (blob != null) {
                    this.log.debug("Found blob from repository '{}' in blobstore '{}'", (Object)existingMove.getName(), (Object)source);
                }
                return blob;
            }
            catch (Exception e) {
                this.log.debug("Exception caught while checking whether blob was being moved from blobstore", (Throwable)e);
                return null;
            }
        }
        this.log.debug("No running move processes for repository '{}'", (Object)sourceRepositoryName);
        return null;
    }
}

