/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.util;

import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;

public final class OrientRFacetUtils {
    private OrientRFacetUtils() {
    }

    public static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, RMetadataUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Nullable
    public static Component findComponent(StorageTx tx, Repository repository, String name, String version, String group) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).and("group").eq((Object)group).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    public static Iterable<Asset> browseAllAssetsByKind(StorageTx tx, Bucket bucket, AssetKind assetKind) {
        Query query = Query.builder().where("attributes.r.asset_kind").eq((Object)assetKind.name()).build();
        return tx.browseAssets(query, bucket);
    }

    public static Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return OrientRFacetUtils.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    public static Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, RMetadataUtils.HASH_ALGORITHMS, null, contentType, false);
        asset.markAsDownloaded();
        tx.saveAsset(asset);
        return OrientRFacetUtils.toContent(asset, assetBlob.getBlob());
    }

    public static AssetKind extractAssetKind(Asset asset) {
        return AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
    }
}

