/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal.hosted;

import com.sonatype.nexus.repository.r.internal.util.PackageValidator;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRHostedFacet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named(value="r")
public class OrientRUploadHandler
extends UploadHandlerSupport {
    private final VariableResolverAdapter variableResolverAdapter;
    private final ContentPermissionChecker contentPermissionChecker;
    private UploadDefinition definition;
    public static final String PATH_ID = "pathId";
    static final String PACKAGE_PATH_DISPLAY = "Package Path";

    @Inject
    public OrientRUploadHandler(@Named(value="simple") @Named(value="simple") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.variableResolverAdapter = variableResolverAdapter;
        this.contentPermissionChecker = contentPermissionChecker;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        AssetUpload assetUpload = (AssetUpload)upload.getAssetUploads().get(0);
        PartPayload payload = assetUpload.getPayload();
        Map fields = assetUpload.getFields();
        String uploadPath = RPathUtils.removeInitialSlashFromPath((String)fields.get(PATH_ID));
        String assetPath = RPathUtils.buildPath(uploadPath, payload.getName());
        this.ensurePermitted(repository.getName(), "r", assetPath, Collections.emptyMap());
        PackageValidator.validateArchiveUploadPath(assetPath);
        try {
            UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
            Asset asset = ((OrientRHostedFacet)repository.facet(OrientRHostedFacet.class)).upload(assetPath, (Payload)payload);
            UploadResponse uploadResponse = new UploadResponse(asset);
            return uploadResponse;
        }
        finally {
            UnitOfWork.end();
        }
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            List<UploadFieldDefinition> assetField = Arrays.asList(new UploadFieldDefinition(PATH_ID, PACKAGE_PATH_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, null));
            this.definition = this.getDefinition("r", false, Collections.emptyList(), assetField, null);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

