/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal.hosted;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.internal.util.RDescriptionUtils;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRFacet;
import com.sonatype.nexus.repository.r.orient.OrientRHostedFacet;
import com.sonatype.nexus.repository.r.orient.internal.hosted.OrientRPackagesBuilder;
import com.sonatype.nexus.repository.r.orient.internal.hosted.OrientRWritePolicySelector;
import com.sonatype.nexus.repository.r.orient.util.OrientRFacetUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRHostedFacetImpl
extends FacetSupport
implements OrientRHostedFacet {
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new OrientRWritePolicySelector());
    }

    @Override
    @TransactionalTouchBlob
    public Content getStoredContent(String contentPath) {
        Preconditions.checkNotNull((Object)contentPath);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientRFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), contentPath);
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return OrientRFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public Asset upload(String path, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)payload);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, RMetadataUtils.HASH_ALGORITHMS);){
            return this.doPutArchive(path, tempBlob, payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Asset doPutArchive(String path, TempBlob archiveContent, Payload payload) throws IOException {
        Map<String, String> attributes;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientRFacet rFacet = (OrientRFacet)this.facet(OrientRFacet.class);
        Throwable throwable = null;
        Object var8_8 = null;
        try (InputStream is = archiveContent.get();){
            attributes = RDescriptionUtils.extractDescriptionFromArchive(path, is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Component component = rFacet.findOrCreateComponent(tx, path, attributes);
        Asset asset = rFacet.findOrCreateAsset(tx, component, path, attributes);
        OrientRFacetUtils.saveAsset(tx, asset, (InputStreamSupplier)archiveContent, payload);
        return asset;
    }

    @Override
    @TransactionalTouchMetadata
    public Content buildAndPutPackagesGz(String basePath) throws IOException {
        Preconditions.checkNotNull((Object)basePath);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientRPackagesBuilder packagesBuilder = new OrientRPackagesBuilder();
        Iterable<Asset> archiveAssets = OrientRFacetUtils.browseAllAssetsByKind(tx, tx.findBucket(this.getRepository()), AssetKind.ARCHIVE);
        StreamSupport.stream(archiveAssets.spliterator(), false).filter(asset -> basePath.equals(RPathUtils.getBasePath(asset.name()))).forEach(packagesBuilder::append);
        byte[] packagesBytes = packagesBuilder.buildPackagesGz();
        StorageFacet storageFacet = (StorageFacet)this.getRepository().facet(StorageFacet.class);
        Throwable throwable = null;
        Object var9_9 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(packagesBytes);){
            TempBlob tempPackagesGz = storageFacet.createTempBlob((InputStream)is, RMetadataUtils.HASH_ALGORITHMS);
            return this.doPutPackagesGz(tx, basePath, tempPackagesGz);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutPackagesGz(StorageTx tx, String basePath, TempBlob tempPackagesGz) throws IOException {
        OrientRFacet rFacet = (OrientRFacet)this.facet(OrientRFacet.class);
        Asset asset = rFacet.findOrCreateAsset(tx, RPathUtils.buildPath(basePath, "PACKAGES.gz"));
        return OrientRFacetUtils.saveAsset(tx, asset, (InputStreamSupplier)tempPackagesGz, "", null);
    }
}

