/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal;

import com.sonatype.nexus.repository.r.internal.util.RDescriptionUtils;
import com.sonatype.nexus.repository.r.orient.OrientRFacet;
import com.sonatype.nexus.repository.r.orient.OrientRRestoreFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRRestoreFacetImpl
extends FacetSupport
implements OrientRRestoreFacet {
    @Override
    @TransactionalTouchBlob
    public void restore(AssetBlob assetBlob, String path) throws IOException {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientRFacet facet = (OrientRFacet)this.facet(OrientRFacet.class);
        if (this.componentRequired(path)) {
            Map<String, String> attributes;
            Throwable throwable = null;
            Object var8_8 = null;
            try (InputStream is = assetBlob.getBlob().getInputStream();){
                attributes = RDescriptionUtils.extractDescriptionFromArchive(path, is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Component component = facet.findOrCreateComponent(tx, path, attributes);
            asset = facet.findOrCreateAsset(tx, component, path, attributes);
        } else {
            asset = facet.findOrCreateAsset(tx, path);
        }
        Optional blobCreated = assetBlob.getCreatedTime();
        boolean newAsset = asset.blobCreated() == null;
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)new AttributesMap()));
        if (newAsset) {
            blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobCreated(arg_0));
        }
        blobCreated.ifPresent(arg_0 -> ((Asset)asset).blobUpdated(arg_0));
        tx.saveAsset(asset);
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository())) != null;
    }

    @Override
    public boolean componentRequired(String name) {
        return !name.contains("/PACKAGES") && !name.endsWith(".rds");
    }

    @Override
    public Query getComponentQuery(Map<String, String> attributes) {
        return Query.builder().where("name").eq((Object)attributes.get("Package")).and("version").eq((Object)attributes.get("Version")).build();
    }

    @Override
    public Map<String, String> extractComponentAttributesFromArchive(String filename, InputStream is) {
        return RDescriptionUtils.extractDescriptionFromArchive(filename, is);
    }
}

