/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal;

import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import com.sonatype.nexus.repository.r.orient.OrientRFacet;
import com.sonatype.nexus.repository.r.orient.util.OrientRFacetUtils;
import java.util.Map;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
public class OrientRFacetImpl
extends FacetSupport
implements OrientRFacet {
    @Override
    public Component findOrCreateComponent(StorageTx tx, String path, Map<String, String> attributes) {
        String name = attributes.get("Package");
        String version = attributes.get("Version");
        String group = RPathUtils.getBasePath(path);
        Component component = OrientRFacetUtils.findComponent(tx, this.getRepository(), name, version, group);
        if (component == null) {
            Bucket bucket = tx.findBucket(this.getRepository());
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(version).group(group);
            tx.saveComponent(component);
        }
        return component;
    }

    @Override
    public Asset findOrCreateAsset(StorageTx tx, Component component, String path, Map<String, String> attributes) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = OrientRFacetUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                asset.formatAttributes().set(attribute.getKey(), (Object)attribute.getValue());
            }
            asset.formatAttributes().set("asset_kind", (Object)RPathUtils.getAssetKind(path).name());
            tx.saveAsset(asset);
        }
        return asset;
    }

    @Override
    public Asset findOrCreateAsset(StorageTx tx, String path) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = OrientRFacetUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)RPathUtils.getAssetKind(path).name());
            tx.saveAsset(asset);
        }
        return asset;
    }
}

