/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.orient.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="r")
public class OrientRBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            String lastSegment = this.lastSegment(asset.name());
            BrowsePaths.appendPath(paths, (String)lastSegment);
            return paths;
        }
        return super.computeAssetPaths(asset, null);
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)component);
        List browsePaths = super.computeComponentPaths(asset, null);
        if (!((BrowsePaths)browsePaths.get(browsePaths.size() - 1)).getDisplayName().equals(component.name())) {
            BrowsePaths.appendPath((List)browsePaths, (String)component.name(), (String)this.computeRequestPath(browsePaths, component.name()));
        }
        BrowsePaths.appendPath((List)browsePaths, (String)component.version(), (String)this.computeRequestPath(browsePaths, component.version()));
        return browsePaths;
    }

    private String computeRequestPath(List<BrowsePaths> browsePaths, String path) {
        return String.valueOf(browsePaths.get(browsePaths.size() - 1).getRequestPath()) + path + "/";
    }
}

