/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.util;

import com.google.common.base.Charsets;
import com.sonatype.nexus.repository.r.internal.RException;
import com.sonatype.nexus.repository.r.internal.util.RMetadataUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public final class RPackagesUtils {
    public static List<Map<String, String>> parseMetadata(InputStream in) {
        ArrayList<Map<String, String>> entries = new ArrayList<Map<String, String>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader inr = new InputStreamReader(in, Charsets.UTF_8);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (BufferedReader br = new BufferedReader(inr);){
                    String content;
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        if (line.trim().isEmpty()) {
                            content = sb.toString();
                            if (!content.trim().isEmpty()) {
                                entries.add(RMetadataUtils.parseDescriptionFile(new ByteArrayInputStream(content.getBytes(Charsets.UTF_8))));
                            }
                            sb = new StringBuilder();
                            continue;
                        }
                        sb.append(line);
                        sb.append('\n');
                    }
                    content = sb.toString();
                    if (!content.trim().isEmpty()) {
                        entries.add(RMetadataUtils.parseDescriptionFile(new ByteArrayInputStream(content.getBytes(Charsets.UTF_8))));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                return entries;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RException(null, e);
        }
    }

    public static Content buildPackages(Collection<Map<String, String>> entries) throws IOException {
        CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CompressorOutputStream cos = compressorStreamFactory.createCompressorOutputStream("gz", (OutputStream)os);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)cos, Charsets.UTF_8);){
                    for (Map<String, String> entry : entries) {
                        InternetHeaders headers = new InternetHeaders();
                        headers.addHeader("Package", entry.get("Package"));
                        headers.addHeader("Version", entry.get("Version"));
                        headers.addHeader("Depends", entry.get("Depends"));
                        headers.addHeader("Imports", entry.get("Imports"));
                        headers.addHeader("Suggests", entry.get("Suggests"));
                        headers.addHeader("LinkingTo", entry.get("LinkingTo"));
                        headers.addHeader("License", entry.get("License"));
                        headers.addHeader("NeedsCompilation", entry.get("NeedsCompilation"));
                        Enumeration headerLines = headers.getAllHeaderLines();
                        while (headerLines.hasMoreElements()) {
                            String line = (String)headerLines.nextElement();
                            writer.write(line, 0, line.length());
                            writer.write(10);
                        }
                        writer.write(10);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (CompressorException e) {
            throw new RException(null, e);
        }
        return new Content((Payload)new BytesPayload(os.toByteArray(), "application/x-gzip"));
    }

    public static List<Map<String, String>> merge(List<List<Map<String, String>>> parts) {
        LinkedHashMap<String, Map<String, String>> merged = new LinkedHashMap<String, Map<String, String>>();
        for (List<Map<String, String>> part : parts) {
            for (Map<String, String> thisEntry : part) {
                merged.putIfAbsent(thisEntry.get("Package"), thisEntry);
            }
        }
        return new ArrayList<Map<String, String>>(merged.values());
    }

    private RPackagesUtils() {
    }
}

