/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.hosted;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import se.sawano.java.text.AlphanumericComparator;

public class RPackageVersion
implements Comparable<RPackageVersion> {
    private static final AlphanumericComparator versionComparator = new AlphanumericComparator(Locale.US);
    private final String originalVersion;
    private final String normalizedVersion;

    public RPackageVersion(String version) {
        this.originalVersion = ((String)Preconditions.checkNotNull((Object)version)).trim();
        this.normalizedVersion = this.originalVersion.replace("-", ".");
    }

    @Override
    public int compareTo(RPackageVersion other) {
        return versionComparator.compare((CharSequence)this.normalizedVersion, (CharSequence)other.normalizedVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RPackageVersion that = (RPackageVersion)o;
        return Objects.equals(this.normalizedVersion, that.normalizedVersion);
    }

    public int hashCode() {
        return Objects.hash(this.normalizedVersion);
    }

    public String toString() {
        return "RPackageVersion{originalVersion='" + this.originalVersion + '\'' + ", normalizedVersion='" + this.normalizedVersion + '\'' + '}';
    }
}

