/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.internal.group;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.r.internal.RException;
import com.sonatype.nexus.repository.r.internal.util.RPackagesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class PackagesGroupHandler
extends GroupHandler {
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        LinkedHashMap responses = this.getAll(context, groupFacet.members(), dispatched);
        List successfulResponses = responses.values().stream().filter(response -> response.getStatus().getCode() == 200 && response.getPayload() != null).collect(Collectors.toList());
        if (successfulResponses.isEmpty()) {
            return this.notFoundResponse(context);
        }
        if (successfulResponses.size() == 1) {
            return (Response)successfulResponses.get(0);
        }
        List<List<Map<String, String>>> parts = successfulResponses.stream().map(this::parseResponse).collect(Collectors.toList());
        List<Map<String, String>> merged = RPackagesUtils.merge(parts);
        return HttpResponses.ok((Payload)RPackagesUtils.buildPackages(merged));
    }

    /*
     * Loose catch block
     */
    protected List<Map<String, String>> parseResponse(@Nonnull Response response) {
        Payload payload = (Payload)Preconditions.checkNotNull((Object)response.getPayload());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = payload.openInputStream();){
                List<Map<String, String>> list;
                CompressorInputStream cin;
                Throwable throwable2;
                block21: {
                    CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
                    throwable2 = null;
                    Object var8_12 = null;
                    cin = compressorStreamFactory.createCompressorInputStream("gz", in);
                    list = RPackagesUtils.parseMetadata((InputStream)cin);
                    if (cin == null) break block21;
                    cin.close();
                }
                return list;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (cin != null) {
                                cin.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException | CompressorException e) {
            throw new RException(null, e);
        }
    }
}

