/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.proxy;

import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;

@Named
@Facet.Exposed
public class RProxyFacet
extends ContentProxyFacetSupport {
    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = RProxyFacet.getAssetKind(context);
        switch (assetKind) {
            case PACKAGES: 
            case RDS_METADATA: 
            case ARCHIVE: {
                return this.getContent(context);
            }
        }
        throw new IllegalArgumentException("Unsupported asset kind " + (Object)((Object)assetKind));
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = RProxyFacet.getAssetKind(context);
        switch (assetKind) {
            case PACKAGES: 
            case RDS_METADATA: {
                return this.storeMetadata(content, assetKind, RPathUtils.extractRequestPath(context));
            }
            case ARCHIVE: {
                return this.storeArchive(content, RPathUtils.extractRequestPath(context));
            }
        }
        throw new IllegalArgumentException("Unsupported asset kind " + (Object)((Object)assetKind));
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    private static AssetKind getAssetKind(Context context) {
        return (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
    }

    private Content getContent(Context context) {
        return ((RContentFacet)this.facet(RContentFacet.class)).getAsset(RPathUtils.extractRequestPath(context)).map(FluentAsset::download).orElse(null);
    }

    private Content storeMetadata(Content content, AssetKind assetKind, String assetPath) {
        return ((RContentFacet)this.facet(RContentFacet.class)).putMetadata((Payload)content, assetPath, assetKind).markAsCached((Payload)content).download();
    }

    private Content storeArchive(Content content, String assetPath) {
        return ((RContentFacet)this.facet(RContentFacet.class)).putPackage((Payload)content, assetPath).markAsCached((Payload)content).download();
    }
}

