/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.datastore.internal.RRecipeSupport;
import com.sonatype.nexus.repository.r.datastore.internal.hosted.RHostedFacet;
import com.sonatype.nexus.repository.r.datastore.internal.hosted.RHostedHandlers;
import com.sonatype.nexus.repository.r.internal.RCommonHandlers;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;

@AvailabilityVersion(from="1.0")
@Singleton
@Named(value="r-hosted")
public class RHostedRecipe
extends RRecipeSupport {
    public static final String NAME = "r-hosted";
    @Inject
    Provider<RContentFacet> contentFacet;
    @Inject
    Provider<RHostedFacet> rHostedFacet;
    @Inject
    RHostedHandlers hostedHandlers;
    @Inject
    RCommonHandlers commonHandlers;
    @Inject
    LastDownloadedHandler lastDownloadedHandler;

    @Inject
    RHostedRecipe(@Named(value="hosted") @Named(value="hosted") Type type, @Named(value="r") @Named(value="r") Format format) {
        super(type, format);
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.maintenanceFacet.get());
        repository.attach((Facet)this.rHostedFacet.get());
        repository.attach((Facet)this.searchFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        builder.route(RHostedRecipe.packagesGzMatcher().handler((Handler)this.timingHandler).handler(this.assetKindHandler(AssetKind.PACKAGES)).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler(this.hostedHandlers::getPackages).create());
        builder.route(RHostedRecipe.archiveMatcher().handler((Handler)this.timingHandler).handler(this.assetKindHandler(AssetKind.ARCHIVE)).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler(this.hostedHandlers::getArchive).create());
        builder.route(RHostedRecipe.uploadMatcher().handler((Handler)this.timingHandler).handler(this.assetKindHandler(AssetKind.ARCHIVE)).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler(this.hostedHandlers::putArchive).create());
        builder.route(RHostedRecipe.notSupportedMetadataMatcher().handler((Handler)this.securityHandler).handler(this.commonHandlers.notSupportedMetadataRequest).create());
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }
}

