/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.sonatype.nexus.repository.r.datastore.internal.hosted.RHostedFacet;
import com.sonatype.nexus.repository.r.internal.util.PackageValidator;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class RHostedHandlers {
    public Response getPackages(Context context) throws Exception {
        String assetPath = RPathUtils.extractRequestPath(context);
        return ((RHostedFacet)context.getRepository().facet(RHostedFacet.class)).getMetadata(assetPath).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    public Response getArchive(Context context) throws Exception {
        String assetPath = RPathUtils.extractRequestPath(context);
        return ((RHostedFacet)context.getRepository().facet(RHostedFacet.class)).getArchive(assetPath).map(HttpResponses::ok).orElseGet(HttpResponses::notFound);
    }

    public Response putArchive(Context context) throws Exception {
        String path = RPathUtils.extractRequestPath(context);
        try {
            PackageValidator.validateArchiveUploadPath(path);
        }
        catch (ValidationErrorsException e) {
            return HttpResponses.badRequest((String)e.getMessage());
        }
        Payload payload = context.getRequest().getPayload();
        ((RHostedFacet)context.getRepository().facet(RHostedFacet.class)).putArchive(path, payload);
        return HttpResponses.ok();
    }
}

