/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.datastore.internal.hosted.RPackagesBuilder;
import com.sonatype.nexus.repository.r.internal.util.RPathUtils;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Facet.Exposed
public class RHostedFacet
extends FacetSupport
implements EventAware.Asynchronous {
    private static final List<Class<? extends AssetEvent>> INTERESTING_ASSET_EVENT_TYPES = Arrays.asList(AssetCreatedEvent.class, AssetDeletedEvent.class, AssetUploadedEvent.class);
    private final Clock clock;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;

    @Inject
    public RHostedFacet(Cooperation2Factory cooperationFactory, Clock clock, @Named(value="${nexus.r.hosted.cooperation.enabled:-true}") @Named(value="${nexus.r.hosted.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.r.hosted.cooperation.majorTimeout:-0s}") @Named(value="${nexus.r.hosted.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.r.hosted.cooperation.minorTimeout:-30s}") @Named(value="${nexus.r.hosted.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.r.hosted.cooperation.threadsPerKey:-100}") @Named(value="${nexus.r.hosted.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.cooperationBuilder = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doStart() {
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":metadata");
    }

    public Optional<Content> getMetadata(String path) throws IOException {
        Optional<Content> metadata = this.content().getAsset(path).map(this::maybeRebuild);
        if (metadata.isPresent()) {
            return metadata;
        }
        return Optional.ofNullable(this.recalculatePackagesGz(RPathUtils.getBasePath(path)));
    }

    public Optional<Content> getArchive(String path) {
        return this.content().getAsset(path).map(FluentAsset::download);
    }

    public void putArchive(String path, Payload payload) {
        this.content().putPackage(payload, path);
    }

    private Content maybeRebuild(FluentAsset metadata) {
        if (!this.isMarkedForRebuild((Asset)metadata)) {
            return metadata.download();
        }
        String basePath = RPathUtils.getBasePath(metadata.path());
        try {
            return this.recalculatePackagesGz(basePath);
        }
        catch (IOException e) {
            this.log.error("Failed rebuilding metadata for repository {} path {}", new Object[]{this.getRepository().getName(), basePath, e});
            return metadata.download();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (this.isInteresting(event)) {
            this.invalidateMetadata(event.getAsset());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentPurgedEvent event) {
        if (this.isRelevant((ContentStoreEvent)event)) {
            this.log.debug("Components purged from {}", (Object)this.getRepository().getName());
            this.content().getAssetsByKind(AssetKind.PACKAGES).forEach(this::invalidateMetadata);
        }
    }

    private Content recalculatePackagesGz(String basePath) throws IOException {
        this.log.info("Rebuilding R PACKAGES.gz metadata for repository {} basePath {}", (Object)this.getRepository().getName(), (Object)basePath);
        return (Content)this.cooperation.on(() -> {
            OffsetDateTime startTime = this.clock.clusterTime();
            RPackagesBuilder builder = new RPackagesBuilder();
            this.content().getArchivesByBasePath(basePath).peek(asset -> this.log.debug("Processing asset {}", asset)).map(asset -> asset.attributes("r")).forEach(formatAttributes -> {
                CancelableHelper.checkCancellation();
                builder.append((NestedAttributesMap)formatAttributes);
            });
            String assetPath = RPathUtils.buildPath(basePath, "PACKAGES.gz");
            BytesPayload payload = new BytesPayload(builder.buildPackagesGz(), null);
            return this.content().putPackagesMetadata(assetPath, (Payload)payload, startTime);
        }).checkFunction(() -> this.content().getAsset(basePath).filter(asset -> !this.isMarkedForRebuild((Asset)asset)).map(FluentAsset::download)).cooperate(basePath, new String[0]);
    }

    private void invalidateMetadata(Asset asset) {
        this.log.debug("Request to invalidate metadata for asset {}", (Object)asset);
        switch (AssetKind.valueOf(asset.kind())) {
            case PACKAGES: {
                this.content().markMetadataDirty(asset);
                break;
            }
            case ARCHIVE: {
                this.content().getAsset(RPathUtils.buildPath(RPathUtils.getBasePath(asset.path()), "PACKAGES.gz")).ifPresent(this::invalidateMetadata);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean isRelevant(ContentStoreEvent event) {
        return event.getRepository().map(this.getRepository()::equals).orElse(false);
    }

    private boolean isInteresting(AssetEvent event) {
        return this.isRelevant((ContentStoreEvent)event) && INTERESTING_ASSET_EVENT_TYPES.stream().anyMatch(clazz -> clazz.isInstance(event)) && AssetKind.ARCHIVE.name().equals(event.getAsset().kind());
    }

    private boolean isMarkedForRebuild(Asset asset) {
        NestedAttributesMap rAttributes = asset.attributes().child("r");
        String dirtyTimeStr = (String)rAttributes.get("dirty_event_time", String.class);
        if (dirtyTimeStr == null) {
            this.log.debug("Metadata {}:{} not marked as dirty", (Object)this.getRepository().getName(), (Object)asset.path());
            return false;
        }
        String rebuildTimeStr = (String)rAttributes.get("rebuilt_time", String.class);
        if (rebuildTimeStr == null) {
            this.log.debug("Metadata {}:{} has no rebuilt timestamp", (Object)this.getRepository().getName(), (Object)asset.path());
            return true;
        }
        this.log.debug("Metadata has rebuild time {} and dirty time {}", (Object)rebuildTimeStr, (Object)dirtyTimeStr);
        OffsetDateTime dirtyTime = OffsetDateTime.parse(dirtyTimeStr);
        OffsetDateTime rebuildTime = OffsetDateTime.parse(rebuildTimeStr);
        return dirtyTime.isAfter(rebuildTime);
    }

    private RContentFacet content() {
        return (RContentFacet)this.getRepository().facet(RContentFacet.class);
    }
}

