/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.r.datastore.internal;

import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import com.sonatype.nexus.repository.r.internal.security.RSecurityFacet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.SuffixMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public abstract class RRecipeSupport
extends RecipeSupport {
    @Inject
    protected Provider<BrowseFacet> browseFacet;
    @Inject
    protected Provider<RSecurityFacet> securityFacet;
    @Inject
    protected Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    protected Provider<RContentFacet> contentFacet;
    @Inject
    protected Provider<SearchFacet> searchFacet;
    @Inject
    protected Provider<LastAssetMaintenanceFacet> maintenanceFacet;
    @Inject
    protected ExceptionHandler exceptionHandler;
    @Inject
    protected TimingHandler timingHandler;
    @Inject
    protected SecurityHandler securityHandler;
    @Inject
    protected RoutingRuleHandler routingRuleHandler;
    @Inject
    protected PartialFetchHandler partialFetchHandler;
    @Inject
    protected ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    protected ContentHeadersHandler contentHeadersHandler;
    @Inject
    protected HandlerContributor handlerContributor;
    @Inject
    protected Provider<HttpClientFacet> httpClientFacet;

    protected RRecipeSupport(Type type, Format format) {
        super(type, format);
    }

    protected Handler assetKindHandler(AssetKind value) {
        return context -> {
            context.getAttributes().set(AssetKind.class, (Object)value);
            return context.proceed();
        };
    }

    protected static Route.Builder packagesMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), RRecipeSupport.packagesTokenMatcher()}));
    }

    protected static Route.Builder packagesGzMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), RRecipeSupport.packagesGzTokenMatcher()}));
    }

    protected static Route.Builder notSupportedMetadataMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), LogicMatchers.or((Matcher[])new Matcher[]{RRecipeSupport.metadataRdsPathMatcher(), RRecipeSupport.packagesTokenMatcher()}), LogicMatchers.not((Matcher)RRecipeSupport.packagesGzTokenMatcher())}));
    }

    protected static Route.Builder metadataPackagesRdsMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), RRecipeSupport.packagesRdsTokenMatcher()}));
    }

    protected static Route.Builder metadataRdsMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), RRecipeSupport.metadataRdsPathMatcher()}));
    }

    protected static Route.Builder archiveMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET", "HEAD"}), RRecipeSupport.archivePathMatcher()}));
    }

    protected static Route.Builder uploadMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"PUT"}), RRecipeSupport.allFilesTokenMatcher()}));
    }

    protected static Route.Builder nonRArchiveUploadMatcher() {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"PUT"}), LogicMatchers.not((Matcher)RRecipeSupport.archivePathMatcher())}));
    }

    protected static Matcher archivePathMatcher() {
        return LogicMatchers.and((Matcher[])new Matcher[]{RRecipeSupport.allFilesTokenMatcher(), LogicMatchers.or((Matcher[])new Matcher[]{RRecipeSupport.suffixMatcherForExtension(".zip"), RRecipeSupport.suffixMatcherForExtension(".tgz"), RRecipeSupport.suffixMatcherForExtension(".tar.gz")})});
    }

    protected static Matcher metadataRdsPathMatcher() {
        return LogicMatchers.and((Matcher[])new Matcher[]{RRecipeSupport.allFilesTokenMatcher(), RRecipeSupport.suffixMatcherForExtension(".rds")});
    }

    protected static TokenMatcher packagesTokenMatcher() {
        return new TokenMatcher("/{path:.+}/PACKAGES{extension:.*}");
    }

    protected static TokenMatcher packagesGzTokenMatcher() {
        return new TokenMatcher("/{path:.+}/PACKAGES.gz");
    }

    protected static TokenMatcher packagesRdsTokenMatcher() {
        return new TokenMatcher("/{path:.+}/PACKAGES.rds");
    }

    protected static TokenMatcher allFilesTokenMatcher() {
        return new TokenMatcher("/{pathAndFilename:.+}");
    }

    protected static SuffixMatcher suffixMatcherForExtension(String extension) {
        return new SuffixMatcher(extension);
    }
}

