/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.r.internal.datastore;

import com.sonatype.nexus.repository.r.AssetKind;
import com.sonatype.nexus.repository.r.datastore.RContentFacet;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="r")
@Singleton
public class RRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    protected RRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = repositoryManager;
    }

    public void after(boolean updateAssets, Repository repository) {
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        Optional rContentFacet = repository.optionalFacet(RContentFacet.class);
        if (!rContentFacet.isPresent()) {
            this.log.warn("Skipping as R Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) {
        String assetPath = data.getBlobName();
        DetachedBlobPayload payload = new DetachedBlobPayload(assetBlob);
        if (this.isMetadata(assetPath)) {
            ((RContentFacet)data.getRepository().facet(RContentFacet.class)).putMetadata((Payload)payload, assetPath, AssetKind.PACKAGES);
        } else {
            ((RContentFacet)data.getRepository().facet(RContentFacet.class)).putPackage((Payload)payload, assetPath);
        }
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return !this.isMetadata(data.getBlobName());
    }

    private boolean isMetadata(String name) {
        return name.contains("/PACKAGES") || name.endsWith(".rds");
    }
}

