/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.analytics;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.nexus.licensing.internal.LicenseUtil;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class LicenseAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    private final LicenseUtil licenseUtil;

    @Inject
    public LicenseAnalytics(LicenseUtil licenseUtil) {
        this.licenseUtil = (LicenseUtil)Preconditions.checkNotNull((Object)licenseUtil);
    }

    @CachedGauge(name="nexus.analytics.license_fingerprint", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public String fingerprint() {
        try {
            return this.licenseUtil.getFingerprint();
        }
        catch (IllegalStateException e) {
            this.log.debug("Unable to get a license fingerprint", (Throwable)e);
            return "";
        }
    }
}

