/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal.ehcache;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Named;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.jsr107.Eh107Configuration;
import org.sonatype.nexus.cache.AbstractCacheBuilder;

@Named(value="ehcache")
public class EhCacheBuilder<K, V>
extends AbstractCacheBuilder<K, V> {
    @Override
    public Cache<K, V> build(CacheManager manager) {
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkNotNull((Object)this.keyType);
        Preconditions.checkNotNull((Object)this.valueType);
        Preconditions.checkNotNull((Object)this.name);
        Preconditions.checkNotNull((Object)this.expiryFactory);
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder((Class)this.keyType, (Class)this.valueType, (Builder)ResourcePoolsBuilder.heap((long)this.cacheSize));
        builder.withExpiry(this.mapToEhCacheExpiry((ExpiryPolicy)this.expiryFactory.create()));
        Cache cache = manager.createCache(this.name, Eh107Configuration.fromEhcacheCacheConfiguration((Builder)builder));
        manager.enableStatistics(this.name, this.statisticsEnabled);
        manager.enableManagement(this.name, this.managementEnabled);
        if (this.persister != null) {
            CacheEventListener listener = cacheEvent -> this.persister.accept(cacheEvent.getKey(), cacheEvent.getOldValue());
            Eh107Configuration configuration = (Eh107Configuration)cache.getConfiguration(Eh107Configuration.class);
            ((CacheRuntimeConfiguration)configuration.unwrap(CacheRuntimeConfiguration.class)).registerCacheEventListener(listener, EventOrdering.UNORDERED, EventFiring.ASYNCHRONOUS, EventType.EVICTED, new EventType[]{EventType.REMOVED, EventType.EXPIRED});
        }
        return cache;
    }

    private org.ehcache.expiry.ExpiryPolicy<K, V> mapToEhCacheExpiry(final ExpiryPolicy policy) {
        return new org.ehcache.expiry.ExpiryPolicy<K, V>(){

            public Duration getExpiryForCreation(K key, V value) {
                return this.toJavaDuration(policy.getExpiryForCreation());
            }

            public Duration getExpiryForAccess(K key, Supplier<? extends V> value) {
                return this.toJavaDuration(policy.getExpiryForAccess());
            }

            public Duration getExpiryForUpdate(K key, Supplier<? extends V> oldValue, V newValue) {
                return this.toJavaDuration(policy.getExpiryForUpdate());
            }

            private Duration toJavaDuration(javax.cache.expiry.Duration duration) {
                if (duration.isEternal()) {
                    return Duration.of(1L, ChronoUnit.FOREVER);
                }
                ChronoUnit chronoUnit = null;
                switch (duration.getTimeUnit()) {
                    case DAYS: {
                        chronoUnit = ChronoUnit.DAYS;
                        break;
                    }
                    case HOURS: {
                        chronoUnit = ChronoUnit.HOURS;
                        break;
                    }
                    case MICROSECONDS: {
                        chronoUnit = ChronoUnit.MICROS;
                        break;
                    }
                    case MILLISECONDS: {
                        chronoUnit = ChronoUnit.MILLIS;
                        break;
                    }
                    case MINUTES: {
                        chronoUnit = ChronoUnit.MINUTES;
                        break;
                    }
                    case NANOSECONDS: {
                        chronoUnit = ChronoUnit.NANOS;
                        break;
                    }
                    case SECONDS: {
                        chronoUnit = ChronoUnit.SECONDS;
                    }
                }
                return Duration.of(duration.getDurationAmount(), chronoUnit);
            }
        };
    }
}

